@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ListFeaturesetVersionMaterializationJobsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property featureWindowEnd End time of the feature window to filter materialization jobs.
 * @property featureWindowStart Start time of the feature window to filter materialization jobs.
 * @property filters Comma-separated list of tag names (and optionally values). Example: tag1,tag2=value2
 * @property name Container name. This is case-sensitive.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property skip Continuation token for pagination.
 * @property version Version identifier. This is case-sensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class ListFeaturesetVersionMaterializationJobsPlainArgs(
    public val featureWindowEnd: String? = null,
    public val featureWindowStart: String? = null,
    public val filters: String? = null,
    public val name: String,
    public val resourceGroupName: String,
    public val skip: String? = null,
    public val version: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ListFeaturesetVersionMaterializationJobsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ListFeaturesetVersionMaterializationJobsPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ListFeaturesetVersionMaterializationJobsPlainArgs.builder()
            .featureWindowEnd(featureWindowEnd?.let({ args0 -> args0 }))
            .featureWindowStart(featureWindowStart?.let({ args0 -> args0 }))
            .filters(filters?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skip(skip?.let({ args0 -> args0 }))
            .version(version.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListFeaturesetVersionMaterializationJobsPlainArgs].
 */
@PulumiTagMarker
public class ListFeaturesetVersionMaterializationJobsPlainArgsBuilder internal constructor() {
    private var featureWindowEnd: String? = null

    private var featureWindowStart: String? = null

    private var filters: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    private var skip: String? = null

    private var version: String? = null

    private var workspaceName: String? = null

    /**
     * @param value End time of the feature window to filter materialization jobs.
     */
    @JvmName("vhbxtosgufpbcdtv")
    public suspend fun featureWindowEnd(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.featureWindowEnd = mapped
    }

    /**
     * @param value Start time of the feature window to filter materialization jobs.
     */
    @JvmName("bpctdufnosnqjihk")
    public suspend fun featureWindowStart(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.featureWindowStart = mapped
    }

    /**
     * @param value Comma-separated list of tag names (and optionally values). Example: tag1,tag2=value2
     */
    @JvmName("imyhtlkdgiuevsyj")
    public suspend fun filters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("vtsrujrqhptfuxdm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xtsrarbhvxdnjlog")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Continuation token for pagination.
     */
    @JvmName("dwurnrtbdebgxbjt")
    public suspend fun skip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skip = mapped
    }

    /**
     * @param value Version identifier. This is case-sensitive.
     */
    @JvmName("pvmvvkkbmsgdfvtm")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.version = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("xgjuvqundrhscpuj")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): ListFeaturesetVersionMaterializationJobsPlainArgs =
        ListFeaturesetVersionMaterializationJobsPlainArgs(
            featureWindowEnd = featureWindowEnd,
            featureWindowStart = featureWindowStart,
            filters = filters,
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            skip = skip,
            version = version ?: throw PulumiNullFieldException("version"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
