@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.LiteralJobInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Literal input type.
 * @property description Description for the input.
 * @property jobInputType Enum to determine the Job Input Type.
 * Expected value is 'literal'.
 * @property value [Required] Literal value for the input.
 */
public data class LiteralJobInputArgs(
    public val description: Output<String>? = null,
    public val jobInputType: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.LiteralJobInputArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.LiteralJobInputArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.LiteralJobInputArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .jobInputType(jobInputType.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LiteralJobInputArgs].
 */
@PulumiTagMarker
public class LiteralJobInputArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var jobInputType: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Description for the input.
     */
    @JvmName("cudrsiusnhiqixgt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Enum to determine the Job Input Type.
     * Expected value is 'literal'.
     */
    @JvmName("hgqudifahcvkbmxn")
    public suspend fun jobInputType(`value`: Output<String>) {
        this.jobInputType = value
    }

    /**
     * @param value [Required] Literal value for the input.
     */
    @JvmName("uqstntxqvupuyhak")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Description for the input.
     */
    @JvmName("glgrocvqfddtvwct")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Enum to determine the Job Input Type.
     * Expected value is 'literal'.
     */
    @JvmName("vhmfmtgcymryqkfv")
    public suspend fun jobInputType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobInputType = mapped
    }

    /**
     * @param value [Required] Literal value for the input.
     */
    @JvmName("vacjelbvbdgydtgf")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): LiteralJobInputArgs = LiteralJobInputArgs(
        description = description,
        jobInputType = jobInputType ?: throw PulumiNullFieldException("jobInputType"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
