@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.MLAssistConfigurationDisabledArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Labeling MLAssist configuration definition when MLAssist is disabled
 * @property mlAssist
 * Expected value is 'Disabled'.
 */
public data class MLAssistConfigurationDisabledArgs(
    public val mlAssist: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.MLAssistConfigurationDisabledArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.MLAssistConfigurationDisabledArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.MLAssistConfigurationDisabledArgs.builder()
            .mlAssist(mlAssist.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MLAssistConfigurationDisabledArgs].
 */
@PulumiTagMarker
public class MLAssistConfigurationDisabledArgsBuilder internal constructor() {
    private var mlAssist: Output<String>? = null

    /**
     * @param value
     * Expected value is 'Disabled'.
     */
    @JvmName("tgvcmewhnvbeujfw")
    public suspend fun mlAssist(`value`: Output<String>) {
        this.mlAssist = value
    }

    /**
     * @param value
     * Expected value is 'Disabled'.
     */
    @JvmName("lsmmrdnaukgtbnsw")
    public suspend fun mlAssist(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mlAssist = mapped
    }

    internal fun build(): MLAssistConfigurationDisabledArgs = MLAssistConfigurationDisabledArgs(
        mlAssist = mlAssist ?: throw PulumiNullFieldException("mlAssist"),
    )
}
