@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.NlpVerticalFeaturizationSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property datasetLanguage Dataset language, useful for the text data.
 */
public data class NlpVerticalFeaturizationSettingsArgs(
    public val datasetLanguage: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.NlpVerticalFeaturizationSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.NlpVerticalFeaturizationSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.NlpVerticalFeaturizationSettingsArgs.builder()
            .datasetLanguage(datasetLanguage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NlpVerticalFeaturizationSettingsArgs].
 */
@PulumiTagMarker
public class NlpVerticalFeaturizationSettingsArgsBuilder internal constructor() {
    private var datasetLanguage: Output<String>? = null

    /**
     * @param value Dataset language, useful for the text data.
     */
    @JvmName("ibnofqeakutbsurv")
    public suspend fun datasetLanguage(`value`: Output<String>) {
        this.datasetLanguage = value
    }

    /**
     * @param value Dataset language, useful for the text data.
     */
    @JvmName("eofbumrjerbamkjn")
    public suspend fun datasetLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasetLanguage = mapped
    }

    internal fun build(): NlpVerticalFeaturizationSettingsArgs = NlpVerticalFeaturizationSettingsArgs(
        datasetLanguage = datasetLanguage,
    )
}
