@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.NotificationSettingArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.EmailNotificationEnableType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Configuration for notification.
 * @property emailOn Send email notification to user on specified notification type
 * @property emails This is the email recipient list which has a limitation of 499 characters in total concat with comma separator
 * @property webhooks Send webhook callback to a service. Key is a user-provided name for the webhook.
 */
public data class NotificationSettingArgs(
    public val emailOn: Output<List<Either<String, EmailNotificationEnableType>>>? = null,
    public val emails: Output<List<String>>? = null,
    public val webhooks: Output<Map<String, AzureDevOpsWebhookArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.NotificationSettingArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.NotificationSettingArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.NotificationSettingArgs.builder()
            .emailOn(
                emailOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .emails(emails?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .webhooks(
                webhooks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NotificationSettingArgs].
 */
@PulumiTagMarker
public class NotificationSettingArgsBuilder internal constructor() {
    private var emailOn: Output<List<Either<String, EmailNotificationEnableType>>>? = null

    private var emails: Output<List<String>>? = null

    private var webhooks: Output<Map<String, AzureDevOpsWebhookArgs>>? = null

    /**
     * @param value Send email notification to user on specified notification type
     */
    @JvmName("kutnmorwiaswxaqn")
    public suspend fun emailOn(`value`: Output<List<Either<String, EmailNotificationEnableType>>>) {
        this.emailOn = value
    }

    @JvmName("mtyyawvsummhmqnm")
    public suspend fun emailOn(vararg values: Output<Either<String, EmailNotificationEnableType>>) {
        this.emailOn = Output.all(values.asList())
    }

    /**
     * @param values Send email notification to user on specified notification type
     */
    @JvmName("ikhvbrwsqxefgdxf")
    public suspend fun emailOn(values: List<Output<Either<String, EmailNotificationEnableType>>>) {
        this.emailOn = Output.all(values)
    }

    /**
     * @param value This is the email recipient list which has a limitation of 499 characters in total concat with comma separator
     */
    @JvmName("buhmjappmjrqswos")
    public suspend fun emails(`value`: Output<List<String>>) {
        this.emails = value
    }

    @JvmName("qgqlvfdtlpfopsga")
    public suspend fun emails(vararg values: Output<String>) {
        this.emails = Output.all(values.asList())
    }

    /**
     * @param values This is the email recipient list which has a limitation of 499 characters in total concat with comma separator
     */
    @JvmName("tsbngkviusiapnyi")
    public suspend fun emails(values: List<Output<String>>) {
        this.emails = Output.all(values)
    }

    /**
     * @param value Send webhook callback to a service. Key is a user-provided name for the webhook.
     */
    @JvmName("yuopgqjkvqmlisds")
    public suspend fun webhooks(`value`: Output<Map<String, AzureDevOpsWebhookArgs>>) {
        this.webhooks = value
    }

    /**
     * @param value Send email notification to user on specified notification type
     */
    @JvmName("lfpyiaortukcxqif")
    public suspend fun emailOn(`value`: List<Either<String, EmailNotificationEnableType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailOn = mapped
    }

    /**
     * @param values Send email notification to user on specified notification type
     */
    @JvmName("fopsmjjirkgwntmb")
    public suspend fun emailOn(vararg values: Either<String, EmailNotificationEnableType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailOn = mapped
    }

    /**
     * @param value This is the email recipient list which has a limitation of 499 characters in total concat with comma separator
     */
    @JvmName("uqugupbdkkfsmauy")
    public suspend fun emails(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emails = mapped
    }

    /**
     * @param values This is the email recipient list which has a limitation of 499 characters in total concat with comma separator
     */
    @JvmName("hvjystsffefkvbrw")
    public suspend fun emails(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emails = mapped
    }

    /**
     * @param value Send webhook callback to a service. Key is a user-provided name for the webhook.
     */
    @JvmName("qsjldmvimyhsbanu")
    public suspend fun webhooks(`value`: Map<String, AzureDevOpsWebhookArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhooks = mapped
    }

    /**
     * @param argument Send webhook callback to a service. Key is a user-provided name for the webhook.
     */
    @JvmName("wjxgjvubjgbelblh")
    public suspend fun webhooks(
        vararg
        argument: Pair<String, suspend AzureDevOpsWebhookArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                AzureDevOpsWebhookArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.webhooks = mapped
    }

    /**
     * @param values Send webhook callback to a service. Key is a user-provided name for the webhook.
     */
    @JvmName("qorgmclseiajfylf")
    public fun webhooks(vararg values: Pair<String, AzureDevOpsWebhookArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.webhooks = mapped
    }

    internal fun build(): NotificationSettingArgs = NotificationSettingArgs(
        emailOn = emailOn,
        emails = emails,
        webhooks = webhooks,
    )
}
