@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.PoolModelConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Model configuration options.
 * @property modelId The URI path to the model.
 */
public data class PoolModelConfigurationArgs(
    public val modelId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.PoolModelConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.PoolModelConfigurationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.PoolModelConfigurationArgs.builder()
            .modelId(modelId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PoolModelConfigurationArgs].
 */
@PulumiTagMarker
public class PoolModelConfigurationArgsBuilder internal constructor() {
    private var modelId: Output<String>? = null

    /**
     * @param value The URI path to the model.
     */
    @JvmName("rqfjhgdkpigwrodk")
    public suspend fun modelId(`value`: Output<String>) {
        this.modelId = value
    }

    /**
     * @param value The URI path to the model.
     */
    @JvmName("wmqmocojcfmyjfue")
    public suspend fun modelId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelId = mapped
    }

    internal fun build(): PoolModelConfigurationArgs = PoolModelConfigurationArgs(
        modelId = modelId,
    )
}
