@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.RandomSamplingAlgorithmArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.RandomSamplingAlgorithmRule
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines a Sampling Algorithm that generates values randomly
 * @property rule The specific type of random algorithm
 * @property samplingAlgorithmType
 * Expected value is 'Random'.
 * @property seed An optional integer to use as the seed for random number generation
 */
public data class RandomSamplingAlgorithmArgs(
    public val rule: Output<Either<String, RandomSamplingAlgorithmRule>>? = null,
    public val samplingAlgorithmType: Output<String>,
    public val seed: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.RandomSamplingAlgorithmArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.RandomSamplingAlgorithmArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.RandomSamplingAlgorithmArgs.builder()
            .rule(
                rule?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .samplingAlgorithmType(samplingAlgorithmType.applyValue({ args0 -> args0 }))
            .seed(seed?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RandomSamplingAlgorithmArgs].
 */
@PulumiTagMarker
public class RandomSamplingAlgorithmArgsBuilder internal constructor() {
    private var rule: Output<Either<String, RandomSamplingAlgorithmRule>>? = null

    private var samplingAlgorithmType: Output<String>? = null

    private var seed: Output<Int>? = null

    /**
     * @param value The specific type of random algorithm
     */
    @JvmName("btaocvshepidrfaa")
    public suspend fun rule(`value`: Output<Either<String, RandomSamplingAlgorithmRule>>) {
        this.rule = value
    }

    /**
     * @param value
     * Expected value is 'Random'.
     */
    @JvmName("lfhxlyvngmnkwkkw")
    public suspend fun samplingAlgorithmType(`value`: Output<String>) {
        this.samplingAlgorithmType = value
    }

    /**
     * @param value An optional integer to use as the seed for random number generation
     */
    @JvmName("ogbovrmpfayrhqde")
    public suspend fun seed(`value`: Output<Int>) {
        this.seed = value
    }

    /**
     * @param value The specific type of random algorithm
     */
    @JvmName("mirkgcfercptgubd")
    public suspend fun rule(`value`: Either<String, RandomSamplingAlgorithmRule>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rule = mapped
    }

    /**
     * @param value The specific type of random algorithm
     */
    @JvmName("fsjlnacklvunwqnr")
    public fun rule(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RandomSamplingAlgorithmRule>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rule = mapped
    }

    /**
     * @param value The specific type of random algorithm
     */
    @JvmName("ffttdtysmjfbjrgi")
    public fun rule(`value`: RandomSamplingAlgorithmRule) {
        val toBeMapped = Either.ofRight<String, RandomSamplingAlgorithmRule>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rule = mapped
    }

    /**
     * @param value
     * Expected value is 'Random'.
     */
    @JvmName("agrqmqhglefsgemg")
    public suspend fun samplingAlgorithmType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.samplingAlgorithmType = mapped
    }

    /**
     * @param value An optional integer to use as the seed for random number generation
     */
    @JvmName("dlcyxllutxeqctws")
    public suspend fun seed(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.seed = mapped
    }

    internal fun build(): RandomSamplingAlgorithmArgs = RandomSamplingAlgorithmArgs(
        rule = rule,
        samplingAlgorithmType = samplingAlgorithmType ?: throw
            PulumiNullFieldException("samplingAlgorithmType"),
        seed = seed,
    )
}
