@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.RegistryPrivateLinkServiceConnectionStateArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.EndpointServiceConnectionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The connection state.
 * @property actionsRequired Some RP chose "None". Other RPs use this for region expansion.
 * @property description User-defined message that, per NRP doc, may be used for approval-related message.
 * @property status Connection status of the service consumer with the service provider
 */
public data class RegistryPrivateLinkServiceConnectionStateArgs(
    public val actionsRequired: Output<String>? = null,
    public val description: Output<String>? = null,
    public val status: Output<Either<String, EndpointServiceConnectionStatus>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.RegistryPrivateLinkServiceConnectionStateArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.RegistryPrivateLinkServiceConnectionStateArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.RegistryPrivateLinkServiceConnectionStateArgs.builder()
            .actionsRequired(actionsRequired?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RegistryPrivateLinkServiceConnectionStateArgs].
 */
@PulumiTagMarker
public class RegistryPrivateLinkServiceConnectionStateArgsBuilder internal constructor() {
    private var actionsRequired: Output<String>? = null

    private var description: Output<String>? = null

    private var status: Output<Either<String, EndpointServiceConnectionStatus>>? = null

    /**
     * @param value Some RP chose "None". Other RPs use this for region expansion.
     */
    @JvmName("yykqlgraublostfh")
    public suspend fun actionsRequired(`value`: Output<String>) {
        this.actionsRequired = value
    }

    /**
     * @param value User-defined message that, per NRP doc, may be used for approval-related message.
     */
    @JvmName("sqseibwpbmtiqpia")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Connection status of the service consumer with the service provider
     */
    @JvmName("gcckvbaoumepgfji")
    public suspend fun status(`value`: Output<Either<String, EndpointServiceConnectionStatus>>) {
        this.status = value
    }

    /**
     * @param value Some RP chose "None". Other RPs use this for region expansion.
     */
    @JvmName("hwakrpreptxfkohk")
    public suspend fun actionsRequired(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value User-defined message that, per NRP doc, may be used for approval-related message.
     */
    @JvmName("dbwpnmyncxamtngx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Connection status of the service consumer with the service provider
     */
    @JvmName("gqrtglsyygkqdsnh")
    public suspend fun status(`value`: Either<String, EndpointServiceConnectionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Connection status of the service consumer with the service provider
     */
    @JvmName("bvdgrxfirvkjvsbk")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EndpointServiceConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Connection status of the service consumer with the service provider
     */
    @JvmName("vmmpexdppyksqplj")
    public fun status(`value`: EndpointServiceConnectionStatus) {
        val toBeMapped = Either.ofRight<String, EndpointServiceConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): RegistryPrivateLinkServiceConnectionStateArgs =
        RegistryPrivateLinkServiceConnectionStateArgs(
            actionsRequired = actionsRequired,
            description = description,
            status = status,
        )
}
