@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.RouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property path [Required] The path for the route.
 * @property port [Required] The port for the route.
 */
public data class RouteArgs(
    public val path: Output<String>,
    public val port: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.RouteArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.RouteArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.RouteArgs.builder()
            .path(path.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteArgs].
 */
@PulumiTagMarker
public class RouteArgsBuilder internal constructor() {
    private var path: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value [Required] The path for the route.
     */
    @JvmName("nmedaxxvkgstirjx")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value [Required] The port for the route.
     */
    @JvmName("mnkdofwojgcxwvlu")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value [Required] The path for the route.
     */
    @JvmName("gwqkvumelreqcpjs")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value [Required] The port for the route.
     */
    @JvmName("aufjthueomvkptln")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): RouteArgs = RouteArgs(
        path = path ?: throw PulumiNullFieldException("path"),
        port = port ?: throw PulumiNullFieldException("port"),
    )
}
