@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.SasDatastoreSecretsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Datastore SAS secrets.
 * @property sasToken Storage container SAS token.
 * @property secretsType Enum to determine the datastore secrets type.
 * Expected value is 'Sas'.
 */
public data class SasDatastoreSecretsArgs(
    public val sasToken: Output<String>? = null,
    public val secretsType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.SasDatastoreSecretsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.SasDatastoreSecretsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.SasDatastoreSecretsArgs.builder()
            .sasToken(sasToken?.applyValue({ args0 -> args0 }))
            .secretsType(secretsType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SasDatastoreSecretsArgs].
 */
@PulumiTagMarker
public class SasDatastoreSecretsArgsBuilder internal constructor() {
    private var sasToken: Output<String>? = null

    private var secretsType: Output<String>? = null

    /**
     * @param value Storage container SAS token.
     */
    @JvmName("yqrqvvvxfbngdaic")
    public suspend fun sasToken(`value`: Output<String>) {
        this.sasToken = value
    }

    /**
     * @param value Enum to determine the datastore secrets type.
     * Expected value is 'Sas'.
     */
    @JvmName("iljtkdmclwqlitnd")
    public suspend fun secretsType(`value`: Output<String>) {
        this.secretsType = value
    }

    /**
     * @param value Storage container SAS token.
     */
    @JvmName("vqsqydqhiippkcis")
    public suspend fun sasToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasToken = mapped
    }

    /**
     * @param value Enum to determine the datastore secrets type.
     * Expected value is 'Sas'.
     */
    @JvmName("wanqrmehgvxqtmwl")
    public suspend fun secretsType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretsType = mapped
    }

    internal fun build(): SasDatastoreSecretsArgs = SasDatastoreSecretsArgs(
        sasToken = sasToken,
        secretsType = secretsType ?: throw PulumiNullFieldException("secretsType"),
    )
}
