@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ServerlessEndpointCapacityReservationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property capacityReservationGroupId [Required] Specifies a capacity reservation group ID to allocate capacity from.
 * @property endpointReservedCapacity Specifies a capacity amount to reserve for this endpoint within the parent capacity reservation group.
 */
public data class ServerlessEndpointCapacityReservationArgs(
    public val capacityReservationGroupId: Output<String>,
    public val endpointReservedCapacity: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ServerlessEndpointCapacityReservationArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ServerlessEndpointCapacityReservationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ServerlessEndpointCapacityReservationArgs.builder()
            .capacityReservationGroupId(capacityReservationGroupId.applyValue({ args0 -> args0 }))
            .endpointReservedCapacity(endpointReservedCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessEndpointCapacityReservationArgs].
 */
@PulumiTagMarker
public class ServerlessEndpointCapacityReservationArgsBuilder internal constructor() {
    private var capacityReservationGroupId: Output<String>? = null

    private var endpointReservedCapacity: Output<Int>? = null

    /**
     * @param value [Required] Specifies a capacity reservation group ID to allocate capacity from.
     */
    @JvmName("yeijufukearejust")
    public suspend fun capacityReservationGroupId(`value`: Output<String>) {
        this.capacityReservationGroupId = value
    }

    /**
     * @param value Specifies a capacity amount to reserve for this endpoint within the parent capacity reservation group.
     */
    @JvmName("wiwyerlinrptdggt")
    public suspend fun endpointReservedCapacity(`value`: Output<Int>) {
        this.endpointReservedCapacity = value
    }

    /**
     * @param value [Required] Specifies a capacity reservation group ID to allocate capacity from.
     */
    @JvmName("fypmaiwlyjdfvfim")
    public suspend fun capacityReservationGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacityReservationGroupId = mapped
    }

    /**
     * @param value Specifies a capacity amount to reserve for this endpoint within the parent capacity reservation group.
     */
    @JvmName("wlicfwqsxiirouwu")
    public suspend fun endpointReservedCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointReservedCapacity = mapped
    }

    internal fun build(): ServerlessEndpointCapacityReservationArgs =
        ServerlessEndpointCapacityReservationArgs(
            capacityReservationGroupId = capacityReservationGroupId ?: throw
                PulumiNullFieldException("capacityReservationGroupId"),
            endpointReservedCapacity = endpointReservedCapacity,
        )
}
