@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ServiceManagedResourcesSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cosmosDb The settings for the service managed cosmosdb account.
 */
public data class ServiceManagedResourcesSettingsArgs(
    public val cosmosDb: Output<CosmosDbSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ServiceManagedResourcesSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ServiceManagedResourcesSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ServiceManagedResourcesSettingsArgs.builder()
            .cosmosDb(cosmosDb?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ServiceManagedResourcesSettingsArgs].
 */
@PulumiTagMarker
public class ServiceManagedResourcesSettingsArgsBuilder internal constructor() {
    private var cosmosDb: Output<CosmosDbSettingsArgs>? = null

    /**
     * @param value The settings for the service managed cosmosdb account.
     */
    @JvmName("oqhtpkwrnxsyigcx")
    public suspend fun cosmosDb(`value`: Output<CosmosDbSettingsArgs>) {
        this.cosmosDb = value
    }

    /**
     * @param value The settings for the service managed cosmosdb account.
     */
    @JvmName("ltbmeknbodwxsyew")
    public suspend fun cosmosDb(`value`: CosmosDbSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cosmosDb = mapped
    }

    /**
     * @param argument The settings for the service managed cosmosdb account.
     */
    @JvmName("lunajholimorbkvo")
    public suspend fun cosmosDb(argument: suspend CosmosDbSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = CosmosDbSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cosmosDb = mapped
    }

    internal fun build(): ServiceManagedResourcesSettingsArgs = ServiceManagedResourcesSettingsArgs(
        cosmosDb = cosmosDb,
    )
}
