@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ServiceTagDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Service Tag destination for a Service Tag Outbound Rule for the managed network of a machine learning workspace.
 * @property portRanges
 * @property protocol
 * @property serviceTag
 */
public data class ServiceTagDestinationArgs(
    public val portRanges: Output<String>? = null,
    public val protocol: Output<String>? = null,
    public val serviceTag: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ServiceTagDestinationArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ServiceTagDestinationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ServiceTagDestinationArgs.builder()
            .portRanges(portRanges?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .serviceTag(serviceTag?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceTagDestinationArgs].
 */
@PulumiTagMarker
public class ServiceTagDestinationArgsBuilder internal constructor() {
    private var portRanges: Output<String>? = null

    private var protocol: Output<String>? = null

    private var serviceTag: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("hbnotyfgxxgcsqiq")
    public suspend fun portRanges(`value`: Output<String>) {
        this.portRanges = value
    }

    /**
     * @param value
     */
    @JvmName("wywpwsiolrsfkgdg")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value
     */
    @JvmName("qtayiuwqeiyflgda")
    public suspend fun serviceTag(`value`: Output<String>) {
        this.serviceTag = value
    }

    /**
     * @param value
     */
    @JvmName("rvmvnosaarxjddur")
    public suspend fun portRanges(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portRanges = mapped
    }

    /**
     * @param value
     */
    @JvmName("wwbtpnbqsykuunss")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value
     */
    @JvmName("cpoagwihnnroeqyk")
    public suspend fun serviceTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceTag = mapped
    }

    internal fun build(): ServiceTagDestinationArgs = ServiceTagDestinationArgs(
        portRanges = portRanges,
        protocol = protocol,
        serviceTag = serviceTag,
    )
}
