@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.SweepJobArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Sweep job definition.
 * @property componentId ARM resource ID of the component resource.
 * @property computeId ARM resource ID of the compute resource.
 * @property description The asset description text.
 * @property displayName Display name of job.
 * @property earlyTermination Early termination policies enable canceling poor-performing runs before they complete
 * @property experimentName The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
 * @property identity Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
 * Defaults to AmlToken if null.
 * @property inputs Mapping of input data bindings used in the job.
 * @property isArchived Is the asset archived?
 * @property jobType Enum to determine the type of job.
 * Expected value is 'Sweep'.
 * @property limits Sweep Job limit.
 * @property objective [Required] Optimization objective.
 * @property outputs Mapping of output data bindings used in the job.
 * @property properties The asset property dictionary.
 * @property samplingAlgorithm [Required] The hyperparameter sampling algorithm
 * @property searchSpace [Required] A dictionary containing each parameter and its distribution. The dictionary key is the name of the parameter
 * @property services List of JobEndpoints.
 * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 * @property trial [Required] Trial component definition.
 */
public data class SweepJobArgs(
    public val componentId: Output<String>? = null,
    public val computeId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val earlyTermination: Output<Any>? = null,
    public val experimentName: Output<String>? = null,
    public val identity: Output<Any>? = null,
    public val inputs: Output<Map<String, Any>>? = null,
    public val isArchived: Output<Boolean>? = null,
    public val jobType: Output<String>,
    public val limits: Output<SweepJobLimitsArgs>? = null,
    public val objective: Output<ObjectiveArgs>,
    public val outputs: Output<Map<String, Any>>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val samplingAlgorithm: Output<Any>,
    public val searchSpace: Output<Any>,
    public val services: Output<Map<String, JobServiceArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trial: Output<TrialComponentArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.SweepJobArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.SweepJobArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.SweepJobArgs.builder()
            .componentId(componentId?.applyValue({ args0 -> args0 }))
            .computeId(computeId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .earlyTermination(earlyTermination?.applyValue({ args0 -> args0 }))
            .experimentName(experimentName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0 }))
            .inputs(inputs?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .isArchived(isArchived?.applyValue({ args0 -> args0 }))
            .jobType(jobType.applyValue({ args0 -> args0 }))
            .limits(limits?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .objective(objective.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .outputs(outputs?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .samplingAlgorithm(samplingAlgorithm.applyValue({ args0 -> args0 }))
            .searchSpace(searchSpace.applyValue({ args0 -> args0 }))
            .services(
                services?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trial(trial.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SweepJobArgs].
 */
@PulumiTagMarker
public class SweepJobArgsBuilder internal constructor() {
    private var componentId: Output<String>? = null

    private var computeId: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var earlyTermination: Output<Any>? = null

    private var experimentName: Output<String>? = null

    private var identity: Output<Any>? = null

    private var inputs: Output<Map<String, Any>>? = null

    private var isArchived: Output<Boolean>? = null

    private var jobType: Output<String>? = null

    private var limits: Output<SweepJobLimitsArgs>? = null

    private var objective: Output<ObjectiveArgs>? = null

    private var outputs: Output<Map<String, Any>>? = null

    private var properties: Output<Map<String, String>>? = null

    private var samplingAlgorithm: Output<Any>? = null

    private var searchSpace: Output<Any>? = null

    private var services: Output<Map<String, JobServiceArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trial: Output<TrialComponentArgs>? = null

    /**
     * @param value ARM resource ID of the component resource.
     */
    @JvmName("gjjyrcrxfevnlcjl")
    public suspend fun componentId(`value`: Output<String>) {
        this.componentId = value
    }

    /**
     * @param value ARM resource ID of the compute resource.
     */
    @JvmName("apqncrsjugbidmln")
    public suspend fun computeId(`value`: Output<String>) {
        this.computeId = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("tnpshbwanqetchff")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Display name of job.
     */
    @JvmName("gorjjpefbjsynmro")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Early termination policies enable canceling poor-performing runs before they complete
     */
    @JvmName("ogcjdyilhpkvymbp")
    public suspend fun earlyTermination(`value`: Output<Any>) {
        this.earlyTermination = value
    }

    /**
     * @param value The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
     */
    @JvmName("yafumudbbcdkxvdr")
    public suspend fun experimentName(`value`: Output<String>) {
        this.experimentName = value
    }

    /**
     * @param value Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
     * Defaults to AmlToken if null.
     */
    @JvmName("qyvbgjfxqbkqnevb")
    public suspend fun identity(`value`: Output<Any>) {
        this.identity = value
    }

    /**
     * @param value Mapping of input data bindings used in the job.
     */
    @JvmName("awfdnhaaawyjhxwa")
    public suspend fun inputs(`value`: Output<Map<String, Any>>) {
        this.inputs = value
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("nnllkbebihjikbsd")
    public suspend fun isArchived(`value`: Output<Boolean>) {
        this.isArchived = value
    }

    /**
     * @param value Enum to determine the type of job.
     * Expected value is 'Sweep'.
     */
    @JvmName("cobqugogylkdiykd")
    public suspend fun jobType(`value`: Output<String>) {
        this.jobType = value
    }

    /**
     * @param value Sweep Job limit.
     */
    @JvmName("cyepljhogihhqbse")
    public suspend fun limits(`value`: Output<SweepJobLimitsArgs>) {
        this.limits = value
    }

    /**
     * @param value [Required] Optimization objective.
     */
    @JvmName("vihmcatipslqvxee")
    public suspend fun objective(`value`: Output<ObjectiveArgs>) {
        this.objective = value
    }

    /**
     * @param value Mapping of output data bindings used in the job.
     */
    @JvmName("eascppqpquvgmpbk")
    public suspend fun outputs(`value`: Output<Map<String, Any>>) {
        this.outputs = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("sjxdjrmeavngvamk")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value [Required] The hyperparameter sampling algorithm
     */
    @JvmName("fscsqsofudyxqfsp")
    public suspend fun samplingAlgorithm(`value`: Output<Any>) {
        this.samplingAlgorithm = value
    }

    /**
     * @param value [Required] A dictionary containing each parameter and its distribution. The dictionary key is the name of the parameter
     */
    @JvmName("jpudbxrynpjfnbfx")
    public suspend fun searchSpace(`value`: Output<Any>) {
        this.searchSpace = value
    }

    /**
     * @param value List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("xqupjgjvaktlljdv")
    public suspend fun services(`value`: Output<Map<String, JobServiceArgs>>) {
        this.services = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("nlwnnnvugrmxfrhi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value [Required] Trial component definition.
     */
    @JvmName("gtlmrcgwmkxhysns")
    public suspend fun trial(`value`: Output<TrialComponentArgs>) {
        this.trial = value
    }

    /**
     * @param value ARM resource ID of the component resource.
     */
    @JvmName("qcdwwerymqpvhgda")
    public suspend fun componentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentId = mapped
    }

    /**
     * @param value ARM resource ID of the compute resource.
     */
    @JvmName("ugtjmfwdvanvnged")
    public suspend fun computeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeId = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("cxrfeqdywgogstea")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Display name of job.
     */
    @JvmName("pwnetndlqeuicayt")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Early termination policies enable canceling poor-performing runs before they complete
     */
    @JvmName("iuvkalsfaygvxhri")
    public suspend fun earlyTermination(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.earlyTermination = mapped
    }

    /**
     * @param value The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
     */
    @JvmName("kxjhhtoakgxktotr")
    public suspend fun experimentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.experimentName = mapped
    }

    /**
     * @param value Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
     * Defaults to AmlToken if null.
     */
    @JvmName("ibrcomiasvwxuhso")
    public suspend fun identity(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param value Mapping of input data bindings used in the job.
     */
    @JvmName("bryjakdqjrpshslf")
    public suspend fun inputs(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param values Mapping of input data bindings used in the job.
     */
    @JvmName("lxhiaywpcqavsinq")
    public fun inputs(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("sihuefnrvbcwqphy")
    public suspend fun isArchived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchived = mapped
    }

    /**
     * @param value Enum to determine the type of job.
     * Expected value is 'Sweep'.
     */
    @JvmName("uwvvipaxxkdaigdi")
    public suspend fun jobType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobType = mapped
    }

    /**
     * @param value Sweep Job limit.
     */
    @JvmName("tayqkvrultgvygmu")
    public suspend fun limits(`value`: SweepJobLimitsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param argument Sweep Job limit.
     */
    @JvmName("aujtwhgchrxwggwe")
    public suspend fun limits(argument: suspend SweepJobLimitsArgsBuilder.() -> Unit) {
        val toBeMapped = SweepJobLimitsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limits = mapped
    }

    /**
     * @param value [Required] Optimization objective.
     */
    @JvmName("tfmwtreratltokkm")
    public suspend fun objective(`value`: ObjectiveArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objective = mapped
    }

    /**
     * @param argument [Required] Optimization objective.
     */
    @JvmName("rrtsjnylhabniurb")
    public suspend fun objective(argument: suspend ObjectiveArgsBuilder.() -> Unit) {
        val toBeMapped = ObjectiveArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.objective = mapped
    }

    /**
     * @param value Mapping of output data bindings used in the job.
     */
    @JvmName("qcpoalkjqjpscwfb")
    public suspend fun outputs(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param values Mapping of output data bindings used in the job.
     */
    @JvmName("ffhqpdureagiuior")
    public fun outputs(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("khqedskfbtfoeynp")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("gyhwxwyrpcsqrors")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value [Required] The hyperparameter sampling algorithm
     */
    @JvmName("jwhkjiwsbdujwrok")
    public suspend fun samplingAlgorithm(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.samplingAlgorithm = mapped
    }

    /**
     * @param value [Required] A dictionary containing each parameter and its distribution. The dictionary key is the name of the parameter
     */
    @JvmName("uvbpvhjphixdrhdg")
    public suspend fun searchSpace(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.searchSpace = mapped
    }

    /**
     * @param value List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("ctlhagsnirmspnbr")
    public suspend fun services(`value`: Map<String, JobServiceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.services = mapped
    }

    /**
     * @param argument List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("ijlqufutbtxnhlks")
    public suspend fun services(
        vararg
        argument: Pair<String, suspend JobServiceArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                JobServiceArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.services = mapped
    }

    /**
     * @param values List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("nphsyuggeeodirko")
    public fun services(vararg values: Pair<String, JobServiceArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.services = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ysdqnnpgonmsbpmt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("holrvdkhngfrvarg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value [Required] Trial component definition.
     */
    @JvmName("omojtdghbdoerbys")
    public suspend fun trial(`value`: TrialComponentArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trial = mapped
    }

    /**
     * @param argument [Required] Trial component definition.
     */
    @JvmName("nqvcituxmoiemgeu")
    public suspend fun trial(argument: suspend TrialComponentArgsBuilder.() -> Unit) {
        val toBeMapped = TrialComponentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trial = mapped
    }

    internal fun build(): SweepJobArgs = SweepJobArgs(
        componentId = componentId,
        computeId = computeId,
        description = description,
        displayName = displayName,
        earlyTermination = earlyTermination,
        experimentName = experimentName,
        identity = identity,
        inputs = inputs,
        isArchived = isArchived,
        jobType = jobType ?: throw PulumiNullFieldException("jobType"),
        limits = limits,
        objective = objective ?: throw PulumiNullFieldException("objective"),
        outputs = outputs,
        properties = properties,
        samplingAlgorithm = samplingAlgorithm ?: throw PulumiNullFieldException("samplingAlgorithm"),
        searchSpace = searchSpace ?: throw PulumiNullFieldException("searchSpace"),
        services = services,
        tags = tags,
        trial = trial ?: throw PulumiNullFieldException("trial"),
    )
}
