@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.SweepJobLimitsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Sweep Job limit class.
 * @property jobLimitsType
 * Expected value is 'Sweep'.
 * @property maxConcurrentTrials Sweep Job max concurrent trials.
 * @property maxTotalTrials Sweep Job max total trials.
 * @property timeout The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
 * @property trialTimeout Sweep Job Trial timeout value.
 */
public data class SweepJobLimitsArgs(
    public val jobLimitsType: Output<String>,
    public val maxConcurrentTrials: Output<Int>? = null,
    public val maxTotalTrials: Output<Int>? = null,
    public val timeout: Output<String>? = null,
    public val trialTimeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.SweepJobLimitsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.SweepJobLimitsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.SweepJobLimitsArgs.builder()
            .jobLimitsType(jobLimitsType.applyValue({ args0 -> args0 }))
            .maxConcurrentTrials(maxConcurrentTrials?.applyValue({ args0 -> args0 }))
            .maxTotalTrials(maxTotalTrials?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .trialTimeout(trialTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SweepJobLimitsArgs].
 */
@PulumiTagMarker
public class SweepJobLimitsArgsBuilder internal constructor() {
    private var jobLimitsType: Output<String>? = null

    private var maxConcurrentTrials: Output<Int>? = null

    private var maxTotalTrials: Output<Int>? = null

    private var timeout: Output<String>? = null

    private var trialTimeout: Output<String>? = null

    /**
     * @param value
     * Expected value is 'Sweep'.
     */
    @JvmName("xblmktkobklfviqk")
    public suspend fun jobLimitsType(`value`: Output<String>) {
        this.jobLimitsType = value
    }

    /**
     * @param value Sweep Job max concurrent trials.
     */
    @JvmName("guhtvshwkqoehfip")
    public suspend fun maxConcurrentTrials(`value`: Output<Int>) {
        this.maxConcurrentTrials = value
    }

    /**
     * @param value Sweep Job max total trials.
     */
    @JvmName("balitdeqdcpfttmc")
    public suspend fun maxTotalTrials(`value`: Output<Int>) {
        this.maxTotalTrials = value
    }

    /**
     * @param value The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
     */
    @JvmName("qginrpvgghmutcab")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value Sweep Job Trial timeout value.
     */
    @JvmName("bvxfuvdemsqdrggs")
    public suspend fun trialTimeout(`value`: Output<String>) {
        this.trialTimeout = value
    }

    /**
     * @param value
     * Expected value is 'Sweep'.
     */
    @JvmName("ugegnnmwpwmokpvs")
    public suspend fun jobLimitsType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobLimitsType = mapped
    }

    /**
     * @param value Sweep Job max concurrent trials.
     */
    @JvmName("yqkygxaqropkxapq")
    public suspend fun maxConcurrentTrials(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentTrials = mapped
    }

    /**
     * @param value Sweep Job max total trials.
     */
    @JvmName("qqxedrrbuaxphrjb")
    public suspend fun maxTotalTrials(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxTotalTrials = mapped
    }

    /**
     * @param value The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
     */
    @JvmName("evshnmrwnvppagcs")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value Sweep Job Trial timeout value.
     */
    @JvmName("fvgthrurlcksvxeq")
    public suspend fun trialTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trialTimeout = mapped
    }

    internal fun build(): SweepJobLimitsArgs = SweepJobLimitsArgs(
        jobLimitsType = jobLimitsType ?: throw PulumiNullFieldException("jobLimitsType"),
        maxConcurrentTrials = maxConcurrentTrials,
        maxTotalTrials = maxTotalTrials,
        timeout = timeout,
        trialTimeout = trialTimeout,
    )
}
