@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.SystemCreatedAcrAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property acrAccountName Name of the ACR account
 * @property acrAccountSku SKU of the ACR account
 * @property armResourceId This is populated once the ACR account is created.
 */
public data class SystemCreatedAcrAccountArgs(
    public val acrAccountName: Output<String>? = null,
    public val acrAccountSku: Output<String>? = null,
    public val armResourceId: Output<ArmResourceIdArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.SystemCreatedAcrAccountArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.SystemCreatedAcrAccountArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.SystemCreatedAcrAccountArgs.builder()
            .acrAccountName(acrAccountName?.applyValue({ args0 -> args0 }))
            .acrAccountSku(acrAccountSku?.applyValue({ args0 -> args0 }))
            .armResourceId(armResourceId?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SystemCreatedAcrAccountArgs].
 */
@PulumiTagMarker
public class SystemCreatedAcrAccountArgsBuilder internal constructor() {
    private var acrAccountName: Output<String>? = null

    private var acrAccountSku: Output<String>? = null

    private var armResourceId: Output<ArmResourceIdArgs>? = null

    /**
     * @param value Name of the ACR account
     */
    @JvmName("mpmoacbhmdrbvatm")
    public suspend fun acrAccountName(`value`: Output<String>) {
        this.acrAccountName = value
    }

    /**
     * @param value SKU of the ACR account
     */
    @JvmName("urteidpshfupcumx")
    public suspend fun acrAccountSku(`value`: Output<String>) {
        this.acrAccountSku = value
    }

    /**
     * @param value This is populated once the ACR account is created.
     */
    @JvmName("ivpjgfqghyqasjtc")
    public suspend fun armResourceId(`value`: Output<ArmResourceIdArgs>) {
        this.armResourceId = value
    }

    /**
     * @param value Name of the ACR account
     */
    @JvmName("ybcheggaslkakuxh")
    public suspend fun acrAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrAccountName = mapped
    }

    /**
     * @param value SKU of the ACR account
     */
    @JvmName("cctaitqrstnwweay")
    public suspend fun acrAccountSku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrAccountSku = mapped
    }

    /**
     * @param value This is populated once the ACR account is created.
     */
    @JvmName("djiehldtelojokwg")
    public suspend fun armResourceId(`value`: ArmResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.armResourceId = mapped
    }

    /**
     * @param argument This is populated once the ACR account is created.
     */
    @JvmName("ewamvopvneaikouj")
    public suspend fun armResourceId(argument: suspend ArmResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = ArmResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.armResourceId = mapped
    }

    internal fun build(): SystemCreatedAcrAccountArgs = SystemCreatedAcrAccountArgs(
        acrAccountName = acrAccountName,
        acrAccountSku = acrAccountSku,
        armResourceId = armResourceId,
    )
}
