@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.TableVerticalFeaturizationSettingsArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.BlockedTransformers
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.FeaturizationMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Featurization Configuration.
 * @property blockedTransformers These transformers shall not be used in featurization.
 * @property columnNameAndTypes Dictionary of column name and its type (int, float, string, datetime etc).
 * @property datasetLanguage Dataset language, useful for the text data.
 * @property enableDnnFeaturization Determines whether to use Dnn based featurizers for data featurization.
 * @property mode Featurization mode - User can keep the default 'Auto' mode and AutoML will take care of necessary transformation of the data in featurization phase.
 * If 'Off' is selected then no featurization is done.
 * If 'Custom' is selected then user can specify additional inputs to customize how featurization is done.
 * @property transformerParams User can specify additional transformers to be used along with the columns to which it would be applied and parameters for the transformer constructor.
 */
public data class TableVerticalFeaturizationSettingsArgs(
    public val blockedTransformers: Output<List<Either<String, BlockedTransformers>>>? = null,
    public val columnNameAndTypes: Output<Map<String, String>>? = null,
    public val datasetLanguage: Output<String>? = null,
    public val enableDnnFeaturization: Output<Boolean>? = null,
    public val mode: Output<Either<String, FeaturizationMode>>? = null,
    public val transformerParams: Output<Map<String, List<ColumnTransformerArgs>>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.TableVerticalFeaturizationSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.TableVerticalFeaturizationSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.TableVerticalFeaturizationSettingsArgs.builder()
            .blockedTransformers(
                blockedTransformers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .columnNameAndTypes(
                columnNameAndTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .datasetLanguage(datasetLanguage?.applyValue({ args0 -> args0 }))
            .enableDnnFeaturization(enableDnnFeaturization?.applyValue({ args0 -> args0 }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .transformerParams(
                transformerParams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.map({ args0 ->
                                args0.let({ args0 ->
                                    args0.toJava()
                                })
                            }),
                        )
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [TableVerticalFeaturizationSettingsArgs].
 */
@PulumiTagMarker
public class TableVerticalFeaturizationSettingsArgsBuilder internal constructor() {
    private var blockedTransformers: Output<List<Either<String, BlockedTransformers>>>? = null

    private var columnNameAndTypes: Output<Map<String, String>>? = null

    private var datasetLanguage: Output<String>? = null

    private var enableDnnFeaturization: Output<Boolean>? = null

    private var mode: Output<Either<String, FeaturizationMode>>? = null

    private var transformerParams: Output<Map<String, List<ColumnTransformerArgs>>>? = null

    /**
     * @param value These transformers shall not be used in featurization.
     */
    @JvmName("hjcdbkxtlvessgss")
    public suspend
    fun blockedTransformers(`value`: Output<List<Either<String, BlockedTransformers>>>) {
        this.blockedTransformers = value
    }

    @JvmName("poeyulgmliqxpqia")
    public suspend fun blockedTransformers(
        vararg
        values: Output<Either<String, BlockedTransformers>>,
    ) {
        this.blockedTransformers = Output.all(values.asList())
    }

    /**
     * @param values These transformers shall not be used in featurization.
     */
    @JvmName("jfbwpqvkfrxwymxq")
    public suspend
    fun blockedTransformers(values: List<Output<Either<String, BlockedTransformers>>>) {
        this.blockedTransformers = Output.all(values)
    }

    /**
     * @param value Dictionary of column name and its type (int, float, string, datetime etc).
     */
    @JvmName("acksnlkcgtgyqeif")
    public suspend fun columnNameAndTypes(`value`: Output<Map<String, String>>) {
        this.columnNameAndTypes = value
    }

    /**
     * @param value Dataset language, useful for the text data.
     */
    @JvmName("ecgbbknsrmiaxcnv")
    public suspend fun datasetLanguage(`value`: Output<String>) {
        this.datasetLanguage = value
    }

    /**
     * @param value Determines whether to use Dnn based featurizers for data featurization.
     */
    @JvmName("vhsevlvbxjavefxy")
    public suspend fun enableDnnFeaturization(`value`: Output<Boolean>) {
        this.enableDnnFeaturization = value
    }

    /**
     * @param value Featurization mode - User can keep the default 'Auto' mode and AutoML will take care of necessary transformation of the data in featurization phase.
     * If 'Off' is selected then no featurization is done.
     * If 'Custom' is selected then user can specify additional inputs to customize how featurization is done.
     */
    @JvmName("jqprsqnlexbfiuau")
    public suspend fun mode(`value`: Output<Either<String, FeaturizationMode>>) {
        this.mode = value
    }

    /**
     * @param value User can specify additional transformers to be used along with the columns to which it would be applied and parameters for the transformer constructor.
     */
    @JvmName("ytuecaylbjvcnjba")
    public suspend fun transformerParams(`value`: Output<Map<String, List<ColumnTransformerArgs>>>) {
        this.transformerParams = value
    }

    /**
     * @param value These transformers shall not be used in featurization.
     */
    @JvmName("hnrqdyyjuwyrfsvb")
    public suspend fun blockedTransformers(`value`: List<Either<String, BlockedTransformers>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockedTransformers = mapped
    }

    /**
     * @param values These transformers shall not be used in featurization.
     */
    @JvmName("ifkhxpfoxbtjcdlw")
    public suspend fun blockedTransformers(vararg values: Either<String, BlockedTransformers>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blockedTransformers = mapped
    }

    /**
     * @param value Dictionary of column name and its type (int, float, string, datetime etc).
     */
    @JvmName("nvqmdlwyqsyxxjuq")
    public suspend fun columnNameAndTypes(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnNameAndTypes = mapped
    }

    /**
     * @param values Dictionary of column name and its type (int, float, string, datetime etc).
     */
    @JvmName("atuvshslpuhhqtmb")
    public fun columnNameAndTypes(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnNameAndTypes = mapped
    }

    /**
     * @param value Dataset language, useful for the text data.
     */
    @JvmName("laodwkhreunxvulj")
    public suspend fun datasetLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasetLanguage = mapped
    }

    /**
     * @param value Determines whether to use Dnn based featurizers for data featurization.
     */
    @JvmName("ysguplmfixqactyd")
    public suspend fun enableDnnFeaturization(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDnnFeaturization = mapped
    }

    /**
     * @param value Featurization mode - User can keep the default 'Auto' mode and AutoML will take care of necessary transformation of the data in featurization phase.
     * If 'Off' is selected then no featurization is done.
     * If 'Custom' is selected then user can specify additional inputs to customize how featurization is done.
     */
    @JvmName("ldvbivbgxbejnvqw")
    public suspend fun mode(`value`: Either<String, FeaturizationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Featurization mode - User can keep the default 'Auto' mode and AutoML will take care of necessary transformation of the data in featurization phase.
     * If 'Off' is selected then no featurization is done.
     * If 'Custom' is selected then user can specify additional inputs to customize how featurization is done.
     */
    @JvmName("shrviogyobvrpqsr")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FeaturizationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Featurization mode - User can keep the default 'Auto' mode and AutoML will take care of necessary transformation of the data in featurization phase.
     * If 'Off' is selected then no featurization is done.
     * If 'Custom' is selected then user can specify additional inputs to customize how featurization is done.
     */
    @JvmName("xndqdjmcmcyrlxpo")
    public fun mode(`value`: FeaturizationMode) {
        val toBeMapped = Either.ofRight<String, FeaturizationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value User can specify additional transformers to be used along with the columns to which it would be applied and parameters for the transformer constructor.
     */
    @JvmName("prwokqqjogopwwfq")
    public suspend fun transformerParams(`value`: Map<String, List<ColumnTransformerArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transformerParams = mapped
    }

    /**
     * @param values User can specify additional transformers to be used along with the columns to which it would be applied and parameters for the transformer constructor.
     */
    @JvmName("kerpfwafkbemsxlu")
    public fun transformerParams(vararg values: Pair<String, List<ColumnTransformerArgs>>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transformerParams = mapped
    }

    internal fun build(): TableVerticalFeaturizationSettingsArgs =
        TableVerticalFeaturizationSettingsArgs(
            blockedTransformers = blockedTransformers,
            columnNameAndTypes = columnNameAndTypes,
            datasetLanguage = datasetLanguage,
            enableDnnFeaturization = enableDnnFeaturization,
            mode = mode,
            transformerParams = transformerParams,
        )
}
