@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.TruncationSelectionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines an early termination policy that cancels a given percentage of runs at each evaluation interval.
 * @property delayEvaluation Number of intervals by which to delay the first evaluation.
 * @property evaluationInterval Interval (number of runs) between policy evaluations.
 * @property policyType
 * Expected value is 'TruncationSelection'.
 * @property truncationPercentage The percentage of runs to cancel at each evaluation interval.
 */
public data class TruncationSelectionPolicyArgs(
    public val delayEvaluation: Output<Int>? = null,
    public val evaluationInterval: Output<Int>? = null,
    public val policyType: Output<String>,
    public val truncationPercentage: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.TruncationSelectionPolicyArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.TruncationSelectionPolicyArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.TruncationSelectionPolicyArgs.builder()
            .delayEvaluation(delayEvaluation?.applyValue({ args0 -> args0 }))
            .evaluationInterval(evaluationInterval?.applyValue({ args0 -> args0 }))
            .policyType(policyType.applyValue({ args0 -> args0 }))
            .truncationPercentage(truncationPercentage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TruncationSelectionPolicyArgs].
 */
@PulumiTagMarker
public class TruncationSelectionPolicyArgsBuilder internal constructor() {
    private var delayEvaluation: Output<Int>? = null

    private var evaluationInterval: Output<Int>? = null

    private var policyType: Output<String>? = null

    private var truncationPercentage: Output<Int>? = null

    /**
     * @param value Number of intervals by which to delay the first evaluation.
     */
    @JvmName("dhkajogyrsrsteok")
    public suspend fun delayEvaluation(`value`: Output<Int>) {
        this.delayEvaluation = value
    }

    /**
     * @param value Interval (number of runs) between policy evaluations.
     */
    @JvmName("yrsbdqthtrwyyhkn")
    public suspend fun evaluationInterval(`value`: Output<Int>) {
        this.evaluationInterval = value
    }

    /**
     * @param value
     * Expected value is 'TruncationSelection'.
     */
    @JvmName("stqohuipunaldtsp")
    public suspend fun policyType(`value`: Output<String>) {
        this.policyType = value
    }

    /**
     * @param value The percentage of runs to cancel at each evaluation interval.
     */
    @JvmName("yedgodvbvvikxvip")
    public suspend fun truncationPercentage(`value`: Output<Int>) {
        this.truncationPercentage = value
    }

    /**
     * @param value Number of intervals by which to delay the first evaluation.
     */
    @JvmName("qoowqdytcxdgagmh")
    public suspend fun delayEvaluation(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delayEvaluation = mapped
    }

    /**
     * @param value Interval (number of runs) between policy evaluations.
     */
    @JvmName("jolumbhimrwgegfp")
    public suspend fun evaluationInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evaluationInterval = mapped
    }

    /**
     * @param value
     * Expected value is 'TruncationSelection'.
     */
    @JvmName("igyudyxauaibhrfn")
    public suspend fun policyType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The percentage of runs to cancel at each evaluation interval.
     */
    @JvmName("qhghntijtjjfwfks")
    public suspend fun truncationPercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.truncationPercentage = mapped
    }

    internal fun build(): TruncationSelectionPolicyArgs = TruncationSelectionPolicyArgs(
        delayEvaluation = delayEvaluation,
        evaluationInterval = evaluationInterval,
        policyType = policyType ?: throw PulumiNullFieldException("policyType"),
        truncationPercentage = truncationPercentage,
    )
}
