@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A user that can be assigned to a compute instance.
 * @property objectId User’s AAD Object Id.
 * @property tenantId User’s AAD Tenant Id.
 */
public data class AssignedUserResponse(
    public val objectId: String,
    public val tenantId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.AssignedUserResponse):
            AssignedUserResponse = AssignedUserResponse(
            objectId = javaType.objectId(),
            tenantId = javaType.tenantId(),
        )
    }
}
