@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountKey  Storage Account Key (Deprecated).
 * @property accountName Storage Account Name.
 * @property areWorkspaceManagedIdentitiesAllowed Indicate if we are using Workspace ManagedIdentities/MSI token (Deprecated).
 * @property blobCacheTimeout  If this is an "DataStoreType.AzureBlob", the length of time (in seconds) to cache files locally after they are accessed (downloaded).
 * @property clientCredentials
 * @property containerName The storage container name.
 * @property credential The credential.
 * @property credentialType  The credential type.
 * @property endpoint The host of the container.
 * @property isSas Indicate if we are using SAS token or Account Key (Deprecated).
 * @property protocol The protocol to use. Defaults to https.
 * @property resourceGroup Resource Group.
 * @property sasToken  SAS Token for the container (Deprecated).
 * @property serviceDataAccessAuthIdentity Indicates which identity to use to authenticate service data access to customer's storage.
 * @property subscriptionId Subscription ID.
 */
public data class AzureStorageSectionResponse(
    public val accountKey: String? = null,
    public val accountName: String? = null,
    public val areWorkspaceManagedIdentitiesAllowed: Boolean? = null,
    public val blobCacheTimeout: Int? = null,
    public val clientCredentials: ClientCredentialsResponse? = null,
    public val containerName: String? = null,
    public val credential: String? = null,
    public val credentialType: String? = null,
    public val endpoint: String? = null,
    public val isSas: Boolean? = null,
    public val protocol: String? = null,
    public val resourceGroup: String? = null,
    public val sasToken: String? = null,
    public val serviceDataAccessAuthIdentity: String? = null,
    public val subscriptionId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.AzureStorageSectionResponse):
            AzureStorageSectionResponse = AzureStorageSectionResponse(
            accountKey = javaType.accountKey().map({ args0 -> args0 }).orElse(null),
            accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
            areWorkspaceManagedIdentitiesAllowed = javaType.areWorkspaceManagedIdentitiesAllowed().map({ args0 ->
                args0
            }).orElse(null),
            blobCacheTimeout = javaType.blobCacheTimeout().map({ args0 -> args0 }).orElse(null),
            clientCredentials = javaType.clientCredentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ClientCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            containerName = javaType.containerName().map({ args0 -> args0 }).orElse(null),
            credential = javaType.credential().map({ args0 -> args0 }).orElse(null),
            credentialType = javaType.credentialType().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint().map({ args0 -> args0 }).orElse(null),
            isSas = javaType.isSas().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            sasToken = javaType.sasToken().map({ args0 -> args0 }).orElse(null),
            serviceDataAccessAuthIdentity = javaType.serviceDataAccessAuthIdentity().map({ args0 ->
                args0
            }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
