@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Batch inference settings per deployment.
 * @property codeConfiguration Code configuration for the endpoint deployment.
 * @property compute Compute target for batch inference operation.
 * @property description Description of the endpoint deployment.
 * @property environmentId ARM resource ID or AssetId of the environment specification for the endpoint deployment.
 * @property environmentVariables Environment variables configuration for the deployment.
 * @property errorThreshold Error threshold, if the error count for the entire input goes above this value,
 * the batch inference will be aborted. Range is [-1, int&#46;MaxValue].
 * For FileDataset, this value is the count of file failures.
 * For TabularDataset, this value is the count of record failures.
 * If set to -1 (the lower bound), all failures during batch inference will be ignored.
 * @property loggingLevel Logging level for batch inference operation.
 * @property maxConcurrencyPerInstance Indicates maximum number of parallelism per instance.
 * @property miniBatchSize Size of the mini-batch passed to each batch invocation.
 * For FileDataset, this is the number of files per mini-batch.
 * For TabularDataset, this is the size of the records in bytes, per mini-batch.
 * @property model Reference to the model asset for the endpoint deployment.
 * @property outputAction Indicates how the output will be organized.
 * @property outputFileName Customized output file name for append_row output action.
 * @property properties Property dictionary. Properties can be added, but not removed or altered.
 * @property provisioningState Provisioning state for the endpoint deployment.
 * @property resources Indicates compute configuration for the job.
 * If not provided, will default to the defaults defined in ResourceConfiguration.
 * @property retrySettings Retry Settings for the batch inference operation.
 * If not provided, will default to the defaults defined in BatchRetrySettings.
 */
public data class BatchDeploymentResponse(
    public val codeConfiguration: CodeConfigurationResponse? = null,
    public val compute: String? = null,
    public val description: String? = null,
    public val environmentId: String? = null,
    public val environmentVariables: Map<String, String>? = null,
    public val errorThreshold: Int? = null,
    public val loggingLevel: String? = null,
    public val maxConcurrencyPerInstance: Int? = null,
    public val miniBatchSize: Double? = null,
    public val model: Any? = null,
    public val outputAction: String? = null,
    public val outputFileName: String? = null,
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
    public val resources: DeploymentResourceConfigurationResponse? = null,
    public val retrySettings: BatchRetrySettingsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.BatchDeploymentResponse):
            BatchDeploymentResponse = BatchDeploymentResponse(
            codeConfiguration = javaType.codeConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CodeConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            compute = javaType.compute().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            environmentId = javaType.environmentId().map({ args0 -> args0 }).orElse(null),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            errorThreshold = javaType.errorThreshold().map({ args0 -> args0 }).orElse(null),
            loggingLevel = javaType.loggingLevel().map({ args0 -> args0 }).orElse(null),
            maxConcurrencyPerInstance = javaType.maxConcurrencyPerInstance().map({ args0 ->
                args0
            }).orElse(null),
            miniBatchSize = javaType.miniBatchSize().map({ args0 -> args0 }).orElse(null),
            model = javaType.model().map({ args0 -> args0 }).orElse(null),
            outputAction = javaType.outputAction().map({ args0 -> args0 }).orElse(null),
            outputFileName = javaType.outputFileName().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DeploymentResourceConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retrySettings = javaType.retrySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.BatchRetrySettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
