@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Column transformer parameters.
 * @property fields Fields to apply transformer logic on.
 * @property parameters Different properties to be passed to transformer.
 * Input expected is dictionary of key,value pairs in JSON format.
 */
public data class ColumnTransformerResponse(
    public val fields: List<String>? = null,
    public val parameters: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ColumnTransformerResponse):
            ColumnTransformerResponse = ColumnTransformerResponse(
            fields = javaType.fields().map({ args0 -> args0 }),
            parameters = javaType.parameters().map({ args0 -> args0 }).orElse(null),
        )
    }
}
