@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines an Aml Instance DataMount.
 * @property createdBy who this data mount created by.
 * @property error Error of this data mount.
 * @property mountAction Mount Action.
 * @property mountName name of the ComputeInstance data mount.
 * @property mountPath Path of this data mount.
 * @property mountState Mount state.
 * @property mountedOn The time when the disk mounted.
 * @property source Source of the ComputeInstance data mount.
 * @property sourceType Data source type.
 */
public data class ComputeInstanceDataMountResponse(
    public val createdBy: String? = null,
    public val error: String? = null,
    public val mountAction: String? = null,
    public val mountName: String? = null,
    public val mountPath: String? = null,
    public val mountState: String? = null,
    public val mountedOn: String? = null,
    public val source: String? = null,
    public val sourceType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ComputeInstanceDataMountResponse):
            ComputeInstanceDataMountResponse = ComputeInstanceDataMountResponse(
            createdBy = javaType.createdBy().map({ args0 -> args0 }).orElse(null),
            error = javaType.error().map({ args0 -> args0 }).orElse(null),
            mountAction = javaType.mountAction().map({ args0 -> args0 }).orElse(null),
            mountName = javaType.mountName().map({ args0 -> args0 }).orElse(null),
            mountPath = javaType.mountPath().map({ args0 -> args0 }).orElse(null),
            mountState = javaType.mountState().map({ args0 -> args0 }).orElse(null),
            mountedOn = javaType.mountedOn().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            sourceType = javaType.sourceType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
