@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Last created Dataset definition.
 * @property createdBy User who created.
 * @property createdTime The dataset creation time (UTC).
 * @property dataPath  Datastore and reference to location of data such as relativePath, Sql Query and etc.
 * @property dataflow Dataflow Json
 * @property datasetDefinitionState Dataset state
 * @property datasetId Unique Dataset identifier.
 * @property description Description about the dataset.
 * @property etag eTag description
 * @property fileType Dataset FileType, specified by user.
 * @property modifiedTime The dataset last modified time (UTC).
 * @property notes Summary of Definition changes.
 * @property partitionFormatInPath Indicates how the source data is partitioned. This is defined to filter on a range of partitioned data before performing actions or materialization.
 * @property properties Properties stores information like name of time series column for time series dataset.
 * @property savedDatasetId Indicates the saved dataset this definition is mapping to, populated on Get.
 * @property tags Tags associated with the dataset.
 * @property telemetryInfo  Telemetry information about the dataset including information like which service the dataset was created from.
 * @property useDescriptionTagsFromDefinition  Whether to use description and tags from the definition level as opposed to dataset level (old behavior).
 * @property versionId An identifier uniquely identifies a definition change.
 */
public data class DatasetResponseLatest(
    public val createdBy: UserInfoResponse? = null,
    public val createdTime: String,
    public val dataPath: DatasetResponseDataPath? = null,
    public val dataflow: String,
    public val datasetDefinitionState: DatasetStateResponse? = null,
    public val datasetId: String,
    public val description: String,
    public val etag: String,
    public val fileType: String,
    public val modifiedTime: String,
    public val notes: String,
    public val partitionFormatInPath: Boolean,
    public val properties: Map<String, Any>? = null,
    public val savedDatasetId: String,
    public val tags: Map<String, String>,
    public val telemetryInfo: Map<String, String>,
    public val useDescriptionTagsFromDefinition: Boolean,
    public val versionId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.DatasetResponseLatest):
            DatasetResponseLatest = DatasetResponseLatest(
            createdBy = javaType.createdBy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.UserInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            createdTime = javaType.createdTime(),
            dataPath = javaType.dataPath().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DatasetResponseDataPath.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataflow = javaType.dataflow(),
            datasetDefinitionState = javaType.datasetDefinitionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DatasetStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            datasetId = javaType.datasetId(),
            description = javaType.description(),
            etag = javaType.etag(),
            fileType = javaType.fileType(),
            modifiedTime = javaType.modifiedTime(),
            notes = javaType.notes(),
            partitionFormatInPath = javaType.partitionFormatInPath(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            savedDatasetId = javaType.savedDatasetId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            telemetryInfo = javaType.telemetryInfo().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            useDescriptionTagsFromDefinition = javaType.useDescriptionTagsFromDefinition(),
            versionId = javaType.versionId(),
        )
    }
}
