@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class to represent configuration settings for Docker Build
 * @property dockerImageUri [Required] Image name of a custom base image.
 * <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
 * @property dockerSpecificationType Enum to determine docker specification type. Must be either Build or Image.
 * Expected value is 'Image'.
 * @property platform The platform information of the docker image.
 */
public data class DockerImageResponse(
    public val dockerImageUri: String,
    public val dockerSpecificationType: String,
    public val platform: DockerImagePlatformResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.DockerImageResponse):
            DockerImageResponse = DockerImageResponse(
            dockerImageUri = javaType.dockerImageUri(),
            dockerSpecificationType = javaType.dockerSpecificationType(),
            platform = javaType.platform().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DockerImagePlatformResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
