@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Environment specification version details.
 * <see href="https://repo2docker.readthedocs.io/en/latest/specification.html" />
 * @property condaFile Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
 * <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
 * @property description The asset description text.
 * @property docker Configuration settings for Docker.
 * @property environmentSpecificationType Environment specification is either user managed or curated by the Azure ML service
 * <see href="https://docs.microsoft.com/en-us/azure/machine-learning/resource-curated-environments" />
 * @property inferenceContainerProperties Defines configuration specific to inference.
 * @property isAnonymous If the name version are system generated (anonymous registration).
 * @property properties The asset property dictionary.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class EnvironmentSpecificationVersionResponse(
    public val condaFile: String? = null,
    public val description: String? = null,
    public val docker: Either<DockerBuildResponse, DockerImageResponse>? = null,
    public val environmentSpecificationType: String,
    public val inferenceContainerProperties: InferenceContainerPropertiesResponse? = null,
    public val isAnonymous: Boolean? = null,
    public val properties: Map<String, String>? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.EnvironmentSpecificationVersionResponse):
            EnvironmentSpecificationVersionResponse = EnvironmentSpecificationVersionResponse(
            condaFile = javaType.condaFile().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            docker = javaType.docker().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DockerBuildResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DockerImageResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            environmentSpecificationType = javaType.environmentSpecificationType(),
            inferenceContainerProperties = javaType.inferenceContainerProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.InferenceContainerPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isAnonymous = javaType.isAnonymous().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
