@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Dto object representing feature
 * @property dataType Specifies type
 * @property description Specifies description
 * @property featureName Specifies name
 * @property tags Specifies tags
 */
public data class FeatureResponse(
    public val dataType: String? = null,
    public val description: String? = null,
    public val featureName: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.FeatureResponse):
            FeatureResponse = FeatureResponse(
            dataType = javaType.dataType().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            featureName = javaType.featureName().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
