@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Linked workspace.
 * @property id ResourceId of the link of the linked workspace.
 * @property name Friendly name of the linked workspace.
 * @property properties LinkedWorkspace specific properties.
 * @property type Resource type of linked workspace.
 */
public data class GetLinkedWorkspaceResult(
    public val id: String,
    public val name: String,
    public val properties: LinkedWorkspacePropsResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.GetLinkedWorkspaceResult):
            GetLinkedWorkspaceResult = GetLinkedWorkspaceResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.LinkedWorkspacePropsResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
