@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identity that will be used to access key vault for encryption at rest
 * @property userAssignedIdentity The ArmId of the user assigned identity that will be used to access the customer managed key vault
 */
public data class IdentityForCmkResponse(
    public val userAssignedIdentity: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.IdentityForCmkResponse):
            IdentityForCmkResponse = IdentityForCmkResponse(
            userAssignedIdentity = javaType.userAssignedIdentity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
