@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Limit settings for the AutoML job.
 * @property maxConcurrentTrials Maximum number of concurrent AutoML iterations.
 * @property maxTrials Maximum number of AutoML iterations.
 * @property timeout AutoML job timeout.
 */
public data class ImageLimitSettingsResponse(
    public val maxConcurrentTrials: Int? = null,
    public val maxTrials: Int? = null,
    public val timeout: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ImageLimitSettingsResponse):
            ImageLimitSettingsResponse = ImageLimitSettingsResponse(
            maxConcurrentTrials = javaType.maxConcurrentTrials().map({ args0 -> args0 }).orElse(null),
            maxTrials = javaType.maxTrials().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
