@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * LinkedWorkspace specific properties.
 * @property linkedWorkspaceResourceId ResourceId of the link target of the linked workspace.
 * @property userAssignedIdentityResourceId ResourceId of the user assigned identity for the linked workspace.
 */
public data class LinkedWorkspacePropsResponse(
    public val linkedWorkspaceResourceId: String? = null,
    public val userAssignedIdentityResourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.LinkedWorkspacePropsResponse):
            LinkedWorkspacePropsResponse = LinkedWorkspacePropsResponse(
            linkedWorkspaceResourceId = javaType.linkedWorkspaceResourceId().map({ args0 ->
                args0
            }).orElse(null),
            userAssignedIdentityResourceId = javaType.userAssignedIdentityResourceId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
