@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Description for the input.
 * @property jobInputType Enum to determine the Job Input Type.
 * Expected value is 'mlflow_model'.
 * @property mode Input Asset Delivery Mode.
 * @property uri [Required] Input Asset URI.
 */
public data class MLFlowModelJobInputResponse(
    public val description: String? = null,
    public val jobInputType: String,
    public val mode: String? = null,
    public val uri: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.MLFlowModelJobInputResponse):
            MLFlowModelJobInputResponse = MLFlowModelJobInputResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            jobInputType = javaType.jobInputType(),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            uri = javaType.uri(),
        )
    }
}
