@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The connection state.
 * @property actionsRequired Some RP chose "None". Other RPs use this for region expansion.
 * @property description User-defined message that, per NRP doc, may be used for approval-related message.
 * @property status Connection status of the service consumer with the service provider
 */
public data class RegistryPrivateLinkServiceConnectionStateResponse(
    public val actionsRequired: String? = null,
    public val description: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.RegistryPrivateLinkServiceConnectionStateResponse):
            RegistryPrivateLinkServiceConnectionStateResponse =
            RegistryPrivateLinkServiceConnectionStateResponse(
                actionsRequired = javaType.actionsRequired().map({ args0 -> args0 }).orElse(null),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
