@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authType Authentication type of the connection target
 * Expected value is 'SAS'.
 * @property category Category of the connection
 * @property credentials
 * @property expiryTime
 * @property metadata
 * @property target
 * @property value Value details of the workspace connection.
 * @property valueFormat format for the workspace connection value
 */
public data class SASAuthTypeWorkspaceConnectionPropertiesResponse(
    public val authType: String,
    public val category: String? = null,
    public val credentials: WorkspaceConnectionSharedAccessSignatureResponse? = null,
    public val expiryTime: String? = null,
    public val metadata: Any? = null,
    public val target: String? = null,
    public val `value`: String? = null,
    public val valueFormat: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.SASAuthTypeWorkspaceConnectionPropertiesResponse):
            SASAuthTypeWorkspaceConnectionPropertiesResponse =
            SASAuthTypeWorkspaceConnectionPropertiesResponse(
                authType = javaType.authType(),
                category = javaType.category().map({ args0 -> args0 }).orElse(null),
                credentials = javaType.credentials().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.WorkspaceConnectionSharedAccessSignatureResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                expiryTime = javaType.expiryTime().map({ args0 -> args0 }).orElse(null),
                metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
                target = javaType.target().map({ args0 -> args0 }).orElse(null),
                `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
                valueFormat = javaType.valueFormat().map({ args0 -> args0 }).orElse(null),
            )
    }
}
