@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Base definition of a schedule
 * @property action [Required] Specifies the action of the schedule
 * @property description The asset description text.
 * @property displayName Display name of schedule.
 * @property isEnabled Is the schedule enabled?
 * @property properties The asset property dictionary.
 * @property provisioningState Provisioning state for the schedule.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 * @property trigger [Required] Specifies the trigger details
 */
public data class ScheduleResponse(
    public val action: Either<EndpointScheduleActionResponse, JobScheduleActionResponse>,
    public val description: String? = null,
    public val displayName: String? = null,
    public val isEnabled: Boolean? = null,
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val trigger: Either<CronTriggerResponse, RecurrenceTriggerResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ScheduleResponse):
            ScheduleResponse = ScheduleResponse(
            action = javaType.action().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EndpointScheduleActionResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.JobScheduleActionResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            trigger = javaType.trigger().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CronTriggerResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RecurrenceTriggerResponse.Companion.toKotlin(args0)
                    })
                },
            ),
        )
    }
}
