@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property capacityReservationGroupId [Required] Specifies a capacity reservation group ID to allocate capacity from.
 * @property endpointReservedCapacity Specifies a capacity amount to reserve for this endpoint within the parent capacity reservation group.
 */
public data class ServerlessEndpointCapacityReservationResponse(
    public val capacityReservationGroupId: String,
    public val endpointReservedCapacity: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ServerlessEndpointCapacityReservationResponse):
            ServerlessEndpointCapacityReservationResponse =
            ServerlessEndpointCapacityReservationResponse(
                capacityReservationGroupId = javaType.capacityReservationGroupId(),
                endpointReservedCapacity = javaType.endpointReservedCapacity().map({ args0 -> args0 }).orElse(null),
            )
    }
}
