@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Featurization Configuration.
 * @property blockedTransformers These transformers shall not be used in featurization.
 * @property columnNameAndTypes Dictionary of column name and its type (int, float, string, datetime etc).
 * @property datasetLanguage Dataset language, useful for the text data.
 * @property enableDnnFeaturization Determines whether to use Dnn based featurizers for data featurization.
 * @property mode Featurization mode - User can keep the default 'Auto' mode and AutoML will take care of necessary transformation of the data in featurization phase.
 * If 'Off' is selected then no featurization is done.
 * If 'Custom' is selected then user can specify additional inputs to customize how featurization is done.
 * @property transformerParams User can specify additional transformers to be used along with the columns to which it would be applied and parameters for the transformer constructor.
 */
public data class TableVerticalFeaturizationSettingsResponse(
    public val blockedTransformers: List<String>? = null,
    public val columnNameAndTypes: Map<String, String>? = null,
    public val datasetLanguage: String? = null,
    public val enableDnnFeaturization: Boolean? = null,
    public val mode: String? = null,
    public val transformerParams: Map<String, List<ColumnTransformerResponse>>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.TableVerticalFeaturizationSettingsResponse):
            TableVerticalFeaturizationSettingsResponse = TableVerticalFeaturizationSettingsResponse(
            blockedTransformers = javaType.blockedTransformers().map({ args0 -> args0 }),
            columnNameAndTypes = javaType.columnNameAndTypes().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            datasetLanguage = javaType.datasetLanguage().map({ args0 -> args0 }).orElse(null),
            enableDnnFeaturization = javaType.enableDnnFeaturization().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            transformerParams = javaType.transformerParams().map({ args0 ->
                args0.key.to(
                    args0.value.map({ args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ColumnTransformerResponse.Companion.toKotlin(args0)
                        })
                    }),
                )
            }).toMap(),
        )
    }
}
