@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin

import com.pulumi.azurenative.maintenance.ConfigurationAssignmentParentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration Assignment
 * Azure REST API version: 2022-11-01-preview. Prior API version in Azure Native 1.x: 2021-04-01-preview.
 * Other available API versions: 2023-04-01, 2023-09-01-preview.
 * ## Example Usage
 * ### ConfigurationAssignments_CreateOrUpdateParent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationAssignmentParent = new AzureNative.Maintenance.ConfigurationAssignmentParent("configurationAssignmentParent", new()
 *     {
 *         ConfigurationAssignmentName = "workervmPolicy",
 *         MaintenanceConfigurationId = "/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/policy1",
 *         ProviderName = "Microsoft.Compute",
 *         ResourceGroupName = "examplerg",
 *         ResourceName = "smdvm1",
 *         ResourceParentName = "smdtest1",
 *         ResourceParentType = "virtualMachineScaleSets",
 *         ResourceType = "virtualMachines",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/maintenance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := maintenance.NewConfigurationAssignmentParent(ctx, "configurationAssignmentParent", &maintenance.ConfigurationAssignmentParentArgs{
 * 			ConfigurationAssignmentName: pulumi.String("workervmPolicy"),
 * 			MaintenanceConfigurationId:  pulumi.String("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/policy1"),
 * 			ProviderName:                pulumi.String("Microsoft.Compute"),
 * 			ResourceGroupName:           pulumi.String("examplerg"),
 * 			ResourceName:                pulumi.String("smdvm1"),
 * 			ResourceParentName:          pulumi.String("smdtest1"),
 * 			ResourceParentType:          pulumi.String("virtualMachineScaleSets"),
 * 			ResourceType:                pulumi.String("virtualMachines"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.maintenance.ConfigurationAssignmentParent;
 * import com.pulumi.azurenative.maintenance.ConfigurationAssignmentParentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationAssignmentParent = new ConfigurationAssignmentParent("configurationAssignmentParent", ConfigurationAssignmentParentArgs.builder()
 *             .configurationAssignmentName("workervmPolicy")
 *             .maintenanceConfigurationId("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/policy1")
 *             .providerName("Microsoft.Compute")
 *             .resourceGroupName("examplerg")
 *             .resourceName("smdvm1")
 *             .resourceParentName("smdtest1")
 *             .resourceParentType("virtualMachineScaleSets")
 *             .resourceType("virtualMachines")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:maintenance:ConfigurationAssignmentParent workervmPolicy /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{providerName}/{resourceParentType}/{resourceParentName}/{resourceType}/{resourceName}/providers/Microsoft.Maintenance/configurationAssignments/{configurationAssignmentName}
 * ```
 * @property configurationAssignmentName Configuration assignment name
 * @property location Location of the resource
 * @property maintenanceConfigurationId The maintenance configuration Id
 * @property providerName Resource provider name
 * @property resourceGroupName Resource group name
 * @property resourceId The unique resourceId
 * @property resourceName Resource identifier
 * @property resourceParentName Resource parent identifier
 * @property resourceParentType Resource parent type
 * @property resourceType Resource type
 */
public data class ConfigurationAssignmentParentArgs(
    public val configurationAssignmentName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val maintenanceConfigurationId: Output<String>? = null,
    public val providerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val resourceParentName: Output<String>? = null,
    public val resourceParentType: Output<String>? = null,
    public val resourceType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.maintenance.ConfigurationAssignmentParentArgs> {
    override fun toJava(): com.pulumi.azurenative.maintenance.ConfigurationAssignmentParentArgs =
        com.pulumi.azurenative.maintenance.ConfigurationAssignmentParentArgs.builder()
            .configurationAssignmentName(configurationAssignmentName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .maintenanceConfigurationId(maintenanceConfigurationId?.applyValue({ args0 -> args0 }))
            .providerName(providerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .resourceParentName(resourceParentName?.applyValue({ args0 -> args0 }))
            .resourceParentType(resourceParentType?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationAssignmentParentArgs].
 */
@PulumiTagMarker
public class ConfigurationAssignmentParentArgsBuilder internal constructor() {
    private var configurationAssignmentName: Output<String>? = null

    private var location: Output<String>? = null

    private var maintenanceConfigurationId: Output<String>? = null

    private var providerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var resourceParentName: Output<String>? = null

    private var resourceParentType: Output<String>? = null

    private var resourceType: Output<String>? = null

    /**
     * @param value Configuration assignment name
     */
    @JvmName("rwtptdcoejsqlokp")
    public suspend fun configurationAssignmentName(`value`: Output<String>) {
        this.configurationAssignmentName = value
    }

    /**
     * @param value Location of the resource
     */
    @JvmName("hvjnanwqxnpjcfmr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The maintenance configuration Id
     */
    @JvmName("prbbyccsmnogsmpt")
    public suspend fun maintenanceConfigurationId(`value`: Output<String>) {
        this.maintenanceConfigurationId = value
    }

    /**
     * @param value Resource provider name
     */
    @JvmName("hrruooshfprepfeb")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value Resource group name
     */
    @JvmName("jdmhhwidkhqwfbek")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The unique resourceId
     */
    @JvmName("koucsvewkuwmiuxx")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Resource identifier
     */
    @JvmName("mflggmotwmjbbrny")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Resource parent identifier
     */
    @JvmName("tgiwohjgglcyqivu")
    public suspend fun resourceParentName(`value`: Output<String>) {
        this.resourceParentName = value
    }

    /**
     * @param value Resource parent type
     */
    @JvmName("vfqkkvjwcgnfpdtf")
    public suspend fun resourceParentType(`value`: Output<String>) {
        this.resourceParentType = value
    }

    /**
     * @param value Resource type
     */
    @JvmName("ydfiursjblxnelyg")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Configuration assignment name
     */
    @JvmName("korgvkmrngxjlodc")
    public suspend fun configurationAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationAssignmentName = mapped
    }

    /**
     * @param value Location of the resource
     */
    @JvmName("xenjksvxrubbxkwe")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The maintenance configuration Id
     */
    @JvmName("aocysufgjsbdkbdl")
    public suspend fun maintenanceConfigurationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceConfigurationId = mapped
    }

    /**
     * @param value Resource provider name
     */
    @JvmName("ecnklgohoocsetrf")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    /**
     * @param value Resource group name
     */
    @JvmName("pbavqicsqyoikrgh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The unique resourceId
     */
    @JvmName("ussgmmgstmegvwqv")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Resource identifier
     */
    @JvmName("bianoetqllkjljnq")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Resource parent identifier
     */
    @JvmName("bqoivhobwaoibvhk")
    public suspend fun resourceParentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceParentName = mapped
    }

    /**
     * @param value Resource parent type
     */
    @JvmName("elsiqcvhrrhtupwc")
    public suspend fun resourceParentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceParentType = mapped
    }

    /**
     * @param value Resource type
     */
    @JvmName("boofjbexorwjsbtn")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    internal fun build(): ConfigurationAssignmentParentArgs = ConfigurationAssignmentParentArgs(
        configurationAssignmentName = configurationAssignmentName,
        location = location,
        maintenanceConfigurationId = maintenanceConfigurationId,
        providerName = providerName,
        resourceGroupName = resourceGroupName,
        resourceId = resourceId,
        resourceName = resourceName,
        resourceParentName = resourceParentName,
        resourceParentType = resourceParentType,
        resourceType = resourceType,
    )
}
