@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin

import com.pulumi.azurenative.maintenance.kotlin.outputs.ConfigurationAssignmentFilterPropertiesResponse
import com.pulumi.azurenative.maintenance.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.maintenance.kotlin.outputs.ConfigurationAssignmentFilterPropertiesResponse.Companion.toKotlin as configurationAssignmentFilterPropertiesResponseToKotlin
import com.pulumi.azurenative.maintenance.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConfigurationAssignmentsForSubscription].
 */
@PulumiTagMarker
public class ConfigurationAssignmentsForSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationAssignmentsForSubscriptionArgs =
        ConfigurationAssignmentsForSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend ConfigurationAssignmentsForSubscriptionArgsBuilder.() -> Unit) {
        val builder = ConfigurationAssignmentsForSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConfigurationAssignmentsForSubscription {
        val builtJavaResource =
            com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForSubscription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConfigurationAssignmentsForSubscription(builtJavaResource)
    }
}

/**
 * Configuration Assignment
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-09-01-preview.
 * ## Example Usage
 * ### ConfigurationAssignmentsForSubscriptions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationAssignmentsForSubscription = new AzureNative.Maintenance.ConfigurationAssignmentsForSubscription("configurationAssignmentsForSubscription", new()
 *     {
 *         ConfigurationAssignmentName = "workervmConfiguration",
 *         Filter = new AzureNative.Maintenance.Inputs.ConfigurationAssignmentFilterPropertiesArgs
 *         {
 *             Locations = new[]
 *             {
 *                 "Japan East",
 *                 "UK South",
 *             },
 *             ResourceGroups = new[]
 *             {
 *                 "RG1",
 *                 "RG2",
 *             },
 *             ResourceTypes = new[]
 *             {
 *                 "Microsoft.HybridCompute/machines",
 *                 "Microsoft.Compute/virtualMachines",
 *             },
 *             TagSettings = new AzureNative.Maintenance.Inputs.TagSettingsPropertiesArgs
 *             {
 *                 FilterOperator = AzureNative.Maintenance.TagOperators.Any,
 *                 Tags =
 *                 {
 *                     { "tag1", new[]
 *                     {
 *                         "tag1Value1",
 *                         "tag1Value2",
 *                         "tag1Value3",
 *                     } },
 *                     { "tag2", new[]
 *                     {
 *                         "tag2Value1",
 *                         "tag2Value2",
 *                         "tag2Value3",
 *                     } },
 *                 },
 *             },
 *         },
 *         MaintenanceConfigurationId = "/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/maintenance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := maintenance.NewConfigurationAssignmentsForSubscription(ctx, "configurationAssignmentsForSubscription", &maintenance.ConfigurationAssignmentsForSubscriptionArgs{
 * 			ConfigurationAssignmentName: pulumi.String("workervmConfiguration"),
 * 			Filter: maintenance.ConfigurationAssignmentFilterPropertiesResponse{
 * 				Locations: pulumi.StringArray{
 * 					pulumi.String("Japan East"),
 * 					pulumi.String("UK South"),
 * 				},
 * 				ResourceGroups: pulumi.StringArray{
 * 					pulumi.String("RG1"),
 * 					pulumi.String("RG2"),
 * 				},
 * 				ResourceTypes: pulumi.StringArray{
 * 					pulumi.String("Microsoft.HybridCompute/machines"),
 * 					pulumi.String("Microsoft.Compute/virtualMachines"),
 * 				},
 * 				TagSettings: &maintenance.TagSettingsPropertiesArgs{
 * 					FilterOperator: maintenance.TagOperatorsAny,
 * 					Tags: pulumi.StringArrayMap{
 * 						"tag1": pulumi.StringArray{
 * 							pulumi.String("tag1Value1"),
 * 							pulumi.String("tag1Value2"),
 * 							pulumi.String("tag1Value3"),
 * 						},
 * 						"tag2": pulumi.StringArray{
 * 							pulumi.String("tag2Value1"),
 * 							pulumi.String("tag2Value2"),
 * 							pulumi.String("tag2Value3"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			MaintenanceConfigurationId: pulumi.String("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForSubscription;
 * import com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationAssignmentsForSubscription = new ConfigurationAssignmentsForSubscription("configurationAssignmentsForSubscription", ConfigurationAssignmentsForSubscriptionArgs.builder()
 *             .configurationAssignmentName("workervmConfiguration")
 *             .filter(Map.ofEntries(
 *                 Map.entry("locations",
 *                     "Japan East",
 *                     "UK South"),
 *                 Map.entry("resourceGroups",
 *                     "RG1",
 *                     "RG2"),
 *                 Map.entry("resourceTypes",
 *                     "Microsoft.HybridCompute/machines",
 *                     "Microsoft.Compute/virtualMachines"),
 *                 Map.entry("tagSettings", Map.ofEntries(
 *                     Map.entry("filterOperator", "Any"),
 *                     Map.entry("tags", Map.ofEntries(
 *                         Map.entry("tag1",
 *                             "tag1Value1",
 *                             "tag1Value2",
 *                             "tag1Value3"),
 *                         Map.entry("tag2",
 *                             "tag2Value1",
 *                             "tag2Value2",
 *                             "tag2Value3")
 *                     ))
 *                 ))
 *             ))
 *             .maintenanceConfigurationId("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:maintenance:ConfigurationAssignmentsForSubscription workervmConfiguration /subscriptions/{subscriptionId}/providers/Microsoft.Maintenance/configurationAssignments/{configurationAssignmentName}
 * ```
 */
public class ConfigurationAssignmentsForSubscription internal constructor(
    override val javaResource:
    com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForSubscription,
) : KotlinCustomResource(javaResource, ConfigurationAssignmentsForSubscriptionMapper) {
    /**
     * Properties of the configuration assignment
     */
    public val filter: Output<ConfigurationAssignmentFilterPropertiesResponse>?
        get() = javaResource.filter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    configurationAssignmentFilterPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Location of the resource
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The maintenance configuration Id
     */
    public val maintenanceConfigurationId: Output<String>?
        get() = javaResource.maintenanceConfigurationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The unique resourceId
     */
    public val resourceId: Output<String>?
        get() = javaResource.resourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Type of the resource
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConfigurationAssignmentsForSubscriptionMapper :
    ResourceMapper<ConfigurationAssignmentsForSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForSubscription::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationAssignmentsForSubscription =
        ConfigurationAssignmentsForSubscription(
            javaResource as
                com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForSubscription,
        )
}

/**
 * @see [ConfigurationAssignmentsForSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationAssignmentsForSubscription].
 */
public suspend fun configurationAssignmentsForSubscription(
    name: String,
    block: suspend ConfigurationAssignmentsForSubscriptionResourceBuilder.() -> Unit,
):
    ConfigurationAssignmentsForSubscription {
    val builder = ConfigurationAssignmentsForSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationAssignmentsForSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationAssignmentsForSubscription(name: String):
    ConfigurationAssignmentsForSubscription {
    val builder = ConfigurationAssignmentsForSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
