@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin

import com.pulumi.azurenative.maintenance.MaintenanceConfigurationArgs.builder
import com.pulumi.azurenative.maintenance.kotlin.enums.MaintenanceScope
import com.pulumi.azurenative.maintenance.kotlin.enums.Visibility
import com.pulumi.azurenative.maintenance.kotlin.inputs.InputPatchConfigurationArgs
import com.pulumi.azurenative.maintenance.kotlin.inputs.InputPatchConfigurationArgsBuilder
import com.pulumi.azurenative.maintenance.kotlin.inputs.MaintenanceOverridePropertiesArgs
import com.pulumi.azurenative.maintenance.kotlin.inputs.MaintenanceOverridePropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Maintenance configuration record type
 * Azure REST API version: 2022-11-01-preview. Prior API version in Azure Native 1.x: 2020-04-01.
 * Other available API versions: 2023-04-01, 2023-09-01-preview.
 * ## Example Usage
 * ### MaintenanceConfigurations_CreateOrUpdateForResource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var maintenanceConfiguration = new AzureNative.Maintenance.MaintenanceConfiguration("maintenanceConfiguration", new()
 *     {
 *         Duration = "05:00",
 *         ExpirationDateTime = "9999-12-31 00:00",
 *         Location = "westus2",
 *         MaintenanceScope = "OSImage",
 *         Namespace = "Microsoft.Maintenance",
 *         RecurEvery = "Day",
 *         ResourceGroupName = "examplerg",
 *         ResourceName = "configuration1",
 *         StartDateTime = "2020-04-30 08:00",
 *         TimeZone = "Pacific Standard Time",
 *         Visibility = "Custom",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/maintenance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := maintenance.NewMaintenanceConfiguration(ctx, "maintenanceConfiguration", &maintenance.MaintenanceConfigurationArgs{
 * 			Duration:           pulumi.String("05:00"),
 * 			ExpirationDateTime: pulumi.String("9999-12-31 00:00"),
 * 			Location:           pulumi.String("westus2"),
 * 			MaintenanceScope:   pulumi.String("OSImage"),
 * 			Namespace:          pulumi.String("Microsoft.Maintenance"),
 * 			RecurEvery:         pulumi.String("Day"),
 * 			ResourceGroupName:  pulumi.String("examplerg"),
 * 			ResourceName:       pulumi.String("configuration1"),
 * 			StartDateTime:      pulumi.String("2020-04-30 08:00"),
 * 			TimeZone:           pulumi.String("Pacific Standard Time"),
 * 			Visibility:         pulumi.String("Custom"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.maintenance.MaintenanceConfiguration;
 * import com.pulumi.azurenative.maintenance.MaintenanceConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var maintenanceConfiguration = new MaintenanceConfiguration("maintenanceConfiguration", MaintenanceConfigurationArgs.builder()
 *             .duration("05:00")
 *             .expirationDateTime("9999-12-31 00:00")
 *             .location("westus2")
 *             .maintenanceScope("OSImage")
 *             .namespace("Microsoft.Maintenance")
 *             .recurEvery("Day")
 *             .resourceGroupName("examplerg")
 *             .resourceName("configuration1")
 *             .startDateTime("2020-04-30 08:00")
 *             .timeZone("Pacific Standard Time")
 *             .visibility("Custom")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:maintenance:MaintenanceConfiguration configuration1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Maintenance/maintenanceConfigurations/{resourceName}
 * ```
 * @property duration Duration of the maintenance window in HH:mm format. If not provided, default value will be used based on maintenance scope provided. Example: 05:00.
 * @property expirationDateTime Effective expiration date of the maintenance window in YYYY-MM-DD hh:mm format. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone. Expiration date must be set to a future date. If not provided, it will be set to the maximum datetime 9999-12-31 23:59:59.
 * @property extensionProperties Gets or sets extensionProperties of the maintenanceConfiguration
 * @property installPatches The input parameters to be passed to the patch run operation.
 * @property location Gets or sets location of the resource
 * @property maintenanceScope Gets or sets maintenanceScope of the configuration
 * @property namespace Gets or sets namespace of the resource
 * @property overrides Override Properties for the maintenance Configuration.
 * @property recurEvery Rate at which a Maintenance window is expected to recur. The rate can be expressed as daily, weekly, or monthly schedules. Daily schedule are formatted as recurEvery: [Frequency as integer]['Day(s)']&#46; If no frequency is provided, the default frequency is 1&#46; Daily schedule examples are recurEvery: Day, recurEvery: 3Days&#46;  Weekly schedule are formatted as recurEvery: [Frequency as integer]['Week(s)'] [Optional comma separated list of weekdays Monday-Sunday]&#46; Weekly schedule examples are recurEvery: 3Weeks, recurEvery: Week Saturday,Sunday&#46; Monthly schedules are formatted as [Frequency as integer]['Month(s)'] [Comma separated list of month days] or [Frequency as integer]['Month(s)'] [Week of Month (First, Second, Third, Fourth, Last)] [Weekday Monday-Sunday] [Optional Offset(No&#46; of days)]. Offset value must be between -6 to 6 inclusive. Monthly schedule examples are recurEvery: Month, recurEvery: 2Months, recurEvery: Month day23,day24, recurEvery: Month Last Sunday, recurEvery: Month Fourth Monday, recurEvery: Month Last Sunday Offset-3, recurEvery: Month Third Sunday Offset6.
 * @property resourceGroupName Resource Group Name
 * @property resourceName Maintenance Configuration Name
 * @property startDateTime Effective start date of the maintenance window in YYYY-MM-DD hh:mm format. The start date can be set to either the current date or future date. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone.
 * @property tags Gets or sets tags of the resource
 * @property timeZone Name of the timezone. List of timezones can be obtained by executing [System&#46;TimeZoneInfo]::GetSystemTimeZones() in PowerShell. Example: Pacific Standard Time, UTC, W. Europe Standard Time, Korea Standard Time, Cen. Australia Standard Time.
 * @property visibility Gets or sets the visibility of the configuration. The default value is 'Custom'
 */
public data class MaintenanceConfigurationArgs(
    public val duration: Output<String>? = null,
    public val expirationDateTime: Output<String>? = null,
    public val extensionProperties: Output<Map<String, String>>? = null,
    public val installPatches: Output<InputPatchConfigurationArgs>? = null,
    public val location: Output<String>? = null,
    public val maintenanceScope: Output<Either<String, MaintenanceScope>>? = null,
    public val namespace: Output<String>? = null,
    public val overrides: Output<List<MaintenanceOverridePropertiesArgs>>? = null,
    public val recurEvery: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val startDateTime: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeZone: Output<String>? = null,
    public val visibility: Output<Either<String, Visibility>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.maintenance.MaintenanceConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.maintenance.MaintenanceConfigurationArgs =
        com.pulumi.azurenative.maintenance.MaintenanceConfigurationArgs.builder()
            .duration(duration?.applyValue({ args0 -> args0 }))
            .expirationDateTime(expirationDateTime?.applyValue({ args0 -> args0 }))
            .extensionProperties(
                extensionProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .installPatches(installPatches?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .maintenanceScope(
                maintenanceScope?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .overrides(
                overrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .recurEvery(recurEvery?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .startDateTime(startDateTime?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 }))
            .visibility(
                visibility?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [MaintenanceConfigurationArgs].
 */
@PulumiTagMarker
public class MaintenanceConfigurationArgsBuilder internal constructor() {
    private var duration: Output<String>? = null

    private var expirationDateTime: Output<String>? = null

    private var extensionProperties: Output<Map<String, String>>? = null

    private var installPatches: Output<InputPatchConfigurationArgs>? = null

    private var location: Output<String>? = null

    private var maintenanceScope: Output<Either<String, MaintenanceScope>>? = null

    private var namespace: Output<String>? = null

    private var overrides: Output<List<MaintenanceOverridePropertiesArgs>>? = null

    private var recurEvery: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var startDateTime: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeZone: Output<String>? = null

    private var visibility: Output<Either<String, Visibility>>? = null

    /**
     * @param value Duration of the maintenance window in HH:mm format. If not provided, default value will be used based on maintenance scope provided. Example: 05:00.
     */
    @JvmName("gjdacioonnursdwa")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value Effective expiration date of the maintenance window in YYYY-MM-DD hh:mm format. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone. Expiration date must be set to a future date. If not provided, it will be set to the maximum datetime 9999-12-31 23:59:59.
     */
    @JvmName("ofdxpdfepqjgtfns")
    public suspend fun expirationDateTime(`value`: Output<String>) {
        this.expirationDateTime = value
    }

    /**
     * @param value Gets or sets extensionProperties of the maintenanceConfiguration
     */
    @JvmName("vsmvyrubygdcdnsi")
    public suspend fun extensionProperties(`value`: Output<Map<String, String>>) {
        this.extensionProperties = value
    }

    /**
     * @param value The input parameters to be passed to the patch run operation.
     */
    @JvmName("pcijqvwqyoihfphy")
    public suspend fun installPatches(`value`: Output<InputPatchConfigurationArgs>) {
        this.installPatches = value
    }

    /**
     * @param value Gets or sets location of the resource
     */
    @JvmName("ctvnwohavaxywufi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Gets or sets maintenanceScope of the configuration
     */
    @JvmName("ocxarijoycphhxdg")
    public suspend fun maintenanceScope(`value`: Output<Either<String, MaintenanceScope>>) {
        this.maintenanceScope = value
    }

    /**
     * @param value Gets or sets namespace of the resource
     */
    @JvmName("eubtsdsodsnsayys")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Override Properties for the maintenance Configuration.
     */
    @JvmName("rkvurmkfonrkjdqj")
    public suspend fun overrides(`value`: Output<List<MaintenanceOverridePropertiesArgs>>) {
        this.overrides = value
    }

    @JvmName("qyuuxqqhtjijejhi")
    public suspend fun overrides(vararg values: Output<MaintenanceOverridePropertiesArgs>) {
        this.overrides = Output.all(values.asList())
    }

    /**
     * @param values Override Properties for the maintenance Configuration.
     */
    @JvmName("evnxdeqhmkpdbang")
    public suspend fun overrides(values: List<Output<MaintenanceOverridePropertiesArgs>>) {
        this.overrides = Output.all(values)
    }

    /**
     * @param value Rate at which a Maintenance window is expected to recur. The rate can be expressed as daily, weekly, or monthly schedules. Daily schedule are formatted as recurEvery: [Frequency as integer]['Day(s)']&#46; If no frequency is provided, the default frequency is 1&#46; Daily schedule examples are recurEvery: Day, recurEvery: 3Days&#46;  Weekly schedule are formatted as recurEvery: [Frequency as integer]['Week(s)'] [Optional comma separated list of weekdays Monday-Sunday]&#46; Weekly schedule examples are recurEvery: 3Weeks, recurEvery: Week Saturday,Sunday&#46; Monthly schedules are formatted as [Frequency as integer]['Month(s)'] [Comma separated list of month days] or [Frequency as integer]['Month(s)'] [Week of Month (First, Second, Third, Fourth, Last)] [Weekday Monday-Sunday] [Optional Offset(No&#46; of days)]. Offset value must be between -6 to 6 inclusive. Monthly schedule examples are recurEvery: Month, recurEvery: 2Months, recurEvery: Month day23,day24, recurEvery: Month Last Sunday, recurEvery: Month Fourth Monday, recurEvery: Month Last Sunday Offset-3, recurEvery: Month Third Sunday Offset6.
     */
    @JvmName("vytgqjwvnntnrvcc")
    public suspend fun recurEvery(`value`: Output<String>) {
        this.recurEvery = value
    }

    /**
     * @param value Resource Group Name
     */
    @JvmName("fipfuwdxdaygfwrr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Maintenance Configuration Name
     */
    @JvmName("csoypsxhaabpfynq")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Effective start date of the maintenance window in YYYY-MM-DD hh:mm format. The start date can be set to either the current date or future date. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone.
     */
    @JvmName("gprsdiovhnogwckv")
    public suspend fun startDateTime(`value`: Output<String>) {
        this.startDateTime = value
    }

    /**
     * @param value Gets or sets tags of the resource
     */
    @JvmName("qinhvtoabmfgktvn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the timezone. List of timezones can be obtained by executing [System&#46;TimeZoneInfo]::GetSystemTimeZones() in PowerShell. Example: Pacific Standard Time, UTC, W. Europe Standard Time, Korea Standard Time, Cen. Australia Standard Time.
     */
    @JvmName("jropoejqrtrqnwqq")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Gets or sets the visibility of the configuration. The default value is 'Custom'
     */
    @JvmName("qjhqwahcxcaaanaa")
    public suspend fun visibility(`value`: Output<Either<String, Visibility>>) {
        this.visibility = value
    }

    /**
     * @param value Duration of the maintenance window in HH:mm format. If not provided, default value will be used based on maintenance scope provided. Example: 05:00.
     */
    @JvmName("awwbuahfuqthjpdb")
    public suspend fun duration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value Effective expiration date of the maintenance window in YYYY-MM-DD hh:mm format. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone. Expiration date must be set to a future date. If not provided, it will be set to the maximum datetime 9999-12-31 23:59:59.
     */
    @JvmName("hbewdtrleayngvro")
    public suspend fun expirationDateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationDateTime = mapped
    }

    /**
     * @param value Gets or sets extensionProperties of the maintenanceConfiguration
     */
    @JvmName("mmbwufbhdogeovqa")
    public suspend fun extensionProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionProperties = mapped
    }

    /**
     * @param values Gets or sets extensionProperties of the maintenanceConfiguration
     */
    @JvmName("rbuteugcinghfrfg")
    public fun extensionProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extensionProperties = mapped
    }

    /**
     * @param value The input parameters to be passed to the patch run operation.
     */
    @JvmName("nylvrvrkxxkdndtl")
    public suspend fun installPatches(`value`: InputPatchConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installPatches = mapped
    }

    /**
     * @param argument The input parameters to be passed to the patch run operation.
     */
    @JvmName("qchhblluibseonbo")
    public suspend
    fun installPatches(argument: suspend InputPatchConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = InputPatchConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.installPatches = mapped
    }

    /**
     * @param value Gets or sets location of the resource
     */
    @JvmName("vlaujqrhonraanqc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Gets or sets maintenanceScope of the configuration
     */
    @JvmName("dmifenyfsjpttgku")
    public suspend fun maintenanceScope(`value`: Either<String, MaintenanceScope>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceScope = mapped
    }

    /**
     * @param value Gets or sets maintenanceScope of the configuration
     */
    @JvmName("mfxaqgwjwgcrioyc")
    public fun maintenanceScope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MaintenanceScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maintenanceScope = mapped
    }

    /**
     * @param value Gets or sets maintenanceScope of the configuration
     */
    @JvmName("wydjkbqstabqghiq")
    public fun maintenanceScope(`value`: MaintenanceScope) {
        val toBeMapped = Either.ofRight<String, MaintenanceScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maintenanceScope = mapped
    }

    /**
     * @param value Gets or sets namespace of the resource
     */
    @JvmName("fepgmtpqjxdpdmvp")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value Override Properties for the maintenance Configuration.
     */
    @JvmName("qlunovvodmhehkhw")
    public suspend fun overrides(`value`: List<MaintenanceOverridePropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrides = mapped
    }

    /**
     * @param argument Override Properties for the maintenance Configuration.
     */
    @JvmName("thcfdnnvkjmplwks")
    public suspend
    fun overrides(argument: List<suspend MaintenanceOverridePropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MaintenanceOverridePropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.overrides = mapped
    }

    /**
     * @param argument Override Properties for the maintenance Configuration.
     */
    @JvmName("edguepqmfrqovldn")
    public suspend fun overrides(
        vararg
        argument: suspend MaintenanceOverridePropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MaintenanceOverridePropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.overrides = mapped
    }

    /**
     * @param argument Override Properties for the maintenance Configuration.
     */
    @JvmName("tnjghkyathvpnlhg")
    public suspend
    fun overrides(argument: suspend MaintenanceOverridePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MaintenanceOverridePropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.overrides = mapped
    }

    /**
     * @param values Override Properties for the maintenance Configuration.
     */
    @JvmName("xstenvcquugjsoux")
    public suspend fun overrides(vararg values: MaintenanceOverridePropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overrides = mapped
    }

    /**
     * @param value Rate at which a Maintenance window is expected to recur. The rate can be expressed as daily, weekly, or monthly schedules. Daily schedule are formatted as recurEvery: [Frequency as integer]['Day(s)']&#46; If no frequency is provided, the default frequency is 1&#46; Daily schedule examples are recurEvery: Day, recurEvery: 3Days&#46;  Weekly schedule are formatted as recurEvery: [Frequency as integer]['Week(s)'] [Optional comma separated list of weekdays Monday-Sunday]&#46; Weekly schedule examples are recurEvery: 3Weeks, recurEvery: Week Saturday,Sunday&#46; Monthly schedules are formatted as [Frequency as integer]['Month(s)'] [Comma separated list of month days] or [Frequency as integer]['Month(s)'] [Week of Month (First, Second, Third, Fourth, Last)] [Weekday Monday-Sunday] [Optional Offset(No&#46; of days)]. Offset value must be between -6 to 6 inclusive. Monthly schedule examples are recurEvery: Month, recurEvery: 2Months, recurEvery: Month day23,day24, recurEvery: Month Last Sunday, recurEvery: Month Fourth Monday, recurEvery: Month Last Sunday Offset-3, recurEvery: Month Third Sunday Offset6.
     */
    @JvmName("cjpdnhhgndomlxxs")
    public suspend fun recurEvery(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurEvery = mapped
    }

    /**
     * @param value Resource Group Name
     */
    @JvmName("kaigigvrhpempalc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Maintenance Configuration Name
     */
    @JvmName("spjgulbkvcwtrjvn")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Effective start date of the maintenance window in YYYY-MM-DD hh:mm format. The start date can be set to either the current date or future date. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone.
     */
    @JvmName("umovphcsmljgtvil")
    public suspend fun startDateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startDateTime = mapped
    }

    /**
     * @param value Gets or sets tags of the resource
     */
    @JvmName("stgojeboyppgcwyn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets tags of the resource
     */
    @JvmName("npbsowaivbwmjixa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the timezone. List of timezones can be obtained by executing [System&#46;TimeZoneInfo]::GetSystemTimeZones() in PowerShell. Example: Pacific Standard Time, UTC, W. Europe Standard Time, Korea Standard Time, Cen. Australia Standard Time.
     */
    @JvmName("xhaoagxnrceljqom")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    /**
     * @param value Gets or sets the visibility of the configuration. The default value is 'Custom'
     */
    @JvmName("dgpngyrhdwcayqra")
    public suspend fun visibility(`value`: Either<String, Visibility>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    /**
     * @param value Gets or sets the visibility of the configuration. The default value is 'Custom'
     */
    @JvmName("pjigaseyvwsifupq")
    public fun visibility(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Visibility>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    /**
     * @param value Gets or sets the visibility of the configuration. The default value is 'Custom'
     */
    @JvmName("oonfolwomkhjklmy")
    public fun visibility(`value`: Visibility) {
        val toBeMapped = Either.ofRight<String, Visibility>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    internal fun build(): MaintenanceConfigurationArgs = MaintenanceConfigurationArgs(
        duration = duration,
        expirationDateTime = expirationDateTime,
        extensionProperties = extensionProperties,
        installPatches = installPatches,
        location = location,
        maintenanceScope = maintenanceScope,
        namespace = namespace,
        overrides = overrides,
        recurEvery = recurEvery,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        startDateTime = startDateTime,
        tags = tags,
        timeZone = timeZone,
        visibility = visibility,
    )
}
