@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Global Task execute once when schedule trigger. Resource task execute for each VM.
 */
public enum class TaskScope(
    public val javaValue: com.pulumi.azurenative.maintenance.enums.TaskScope,
) : ConvertibleToJava<com.pulumi.azurenative.maintenance.enums.TaskScope> {
    Global(com.pulumi.azurenative.maintenance.enums.TaskScope.Global),
    Resource(com.pulumi.azurenative.maintenance.enums.TaskScope.Resource),
    ;

    override fun toJava(): com.pulumi.azurenative.maintenance.enums.TaskScope = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.maintenance.enums.TaskScope): TaskScope =
            TaskScope.values().first { it.javaValue == javaType }
    }
}
