@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.inputs

import com.pulumi.azurenative.maintenance.inputs.ConfigurationAssignmentFilterPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure query for the update configuration.
 * @property locations List of locations to scope the query to.
 * @property osTypes List of allowed operating systems.
 * @property resourceGroups List of allowed resource groups.
 * @property resourceTypes List of allowed resources.
 * @property tagSettings Tag settings for the VM.
 */
public data class ConfigurationAssignmentFilterPropertiesArgs(
    public val locations: Output<List<String>>? = null,
    public val osTypes: Output<List<String>>? = null,
    public val resourceGroups: Output<List<String>>? = null,
    public val resourceTypes: Output<List<String>>? = null,
    public val tagSettings: Output<TagSettingsPropertiesArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.maintenance.inputs.ConfigurationAssignmentFilterPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.maintenance.inputs.ConfigurationAssignmentFilterPropertiesArgs =
        com.pulumi.azurenative.maintenance.inputs.ConfigurationAssignmentFilterPropertiesArgs.builder()
            .locations(locations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .osTypes(osTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroups(resourceGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceTypes(resourceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tagSettings(tagSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConfigurationAssignmentFilterPropertiesArgs].
 */
@PulumiTagMarker
public class ConfigurationAssignmentFilterPropertiesArgsBuilder internal constructor() {
    private var locations: Output<List<String>>? = null

    private var osTypes: Output<List<String>>? = null

    private var resourceGroups: Output<List<String>>? = null

    private var resourceTypes: Output<List<String>>? = null

    private var tagSettings: Output<TagSettingsPropertiesArgs>? = null

    /**
     * @param value List of locations to scope the query to.
     */
    @JvmName("qaegkskfycaxmdfb")
    public suspend fun locations(`value`: Output<List<String>>) {
        this.locations = value
    }

    @JvmName("sheludftstpdbhyp")
    public suspend fun locations(vararg values: Output<String>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values List of locations to scope the query to.
     */
    @JvmName("xehwgybiefacnjqp")
    public suspend fun locations(values: List<Output<String>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value List of allowed operating systems.
     */
    @JvmName("xsmlrrxumgqqjfsm")
    public suspend fun osTypes(`value`: Output<List<String>>) {
        this.osTypes = value
    }

    @JvmName("lmmgnrwogyajkfhv")
    public suspend fun osTypes(vararg values: Output<String>) {
        this.osTypes = Output.all(values.asList())
    }

    /**
     * @param values List of allowed operating systems.
     */
    @JvmName("awwnslgdkmgnvlhj")
    public suspend fun osTypes(values: List<Output<String>>) {
        this.osTypes = Output.all(values)
    }

    /**
     * @param value List of allowed resource groups.
     */
    @JvmName("dqjbumummuoycfam")
    public suspend fun resourceGroups(`value`: Output<List<String>>) {
        this.resourceGroups = value
    }

    @JvmName("ajmlbgmcshsnbejg")
    public suspend fun resourceGroups(vararg values: Output<String>) {
        this.resourceGroups = Output.all(values.asList())
    }

    /**
     * @param values List of allowed resource groups.
     */
    @JvmName("qacwwlfgabnnokqo")
    public suspend fun resourceGroups(values: List<Output<String>>) {
        this.resourceGroups = Output.all(values)
    }

    /**
     * @param value List of allowed resources.
     */
    @JvmName("ftduyyctrxqoblbq")
    public suspend fun resourceTypes(`value`: Output<List<String>>) {
        this.resourceTypes = value
    }

    @JvmName("hssxjidrsyeecjcq")
    public suspend fun resourceTypes(vararg values: Output<String>) {
        this.resourceTypes = Output.all(values.asList())
    }

    /**
     * @param values List of allowed resources.
     */
    @JvmName("nsrkyxuirgwxmmew")
    public suspend fun resourceTypes(values: List<Output<String>>) {
        this.resourceTypes = Output.all(values)
    }

    /**
     * @param value Tag settings for the VM.
     */
    @JvmName("rblwfsumirvcqwuu")
    public suspend fun tagSettings(`value`: Output<TagSettingsPropertiesArgs>) {
        this.tagSettings = value
    }

    /**
     * @param value List of locations to scope the query to.
     */
    @JvmName("bxffmmctyedjahmo")
    public suspend fun locations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param values List of locations to scope the query to.
     */
    @JvmName("dubbfkdifdjkhlsx")
    public suspend fun locations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value List of allowed operating systems.
     */
    @JvmName("yxyeqgokkqhrrirg")
    public suspend fun osTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osTypes = mapped
    }

    /**
     * @param values List of allowed operating systems.
     */
    @JvmName("jpgjfpnheomhilrd")
    public suspend fun osTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osTypes = mapped
    }

    /**
     * @param value List of allowed resource groups.
     */
    @JvmName("qxbcllpcmaabdajg")
    public suspend fun resourceGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroups = mapped
    }

    /**
     * @param values List of allowed resource groups.
     */
    @JvmName("jtehtivkernbmpdh")
    public suspend fun resourceGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGroups = mapped
    }

    /**
     * @param value List of allowed resources.
     */
    @JvmName("nqgpbhyjhcejmakm")
    public suspend fun resourceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param values List of allowed resources.
     */
    @JvmName("nmifwflapfkksmbn")
    public suspend fun resourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param value Tag settings for the VM.
     */
    @JvmName("yidxawbbucectfjm")
    public suspend fun tagSettings(`value`: TagSettingsPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagSettings = mapped
    }

    /**
     * @param argument Tag settings for the VM.
     */
    @JvmName("ybrjddhrenosffnt")
    public suspend fun tagSettings(argument: suspend TagSettingsPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TagSettingsPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tagSettings = mapped
    }

    internal fun build(): ConfigurationAssignmentFilterPropertiesArgs =
        ConfigurationAssignmentFilterPropertiesArgs(
            locations = locations,
            osTypes = osTypes,
            resourceGroups = resourceGroups,
            resourceTypes = resourceTypes,
            tagSettings = tagSettings,
        )
}
