@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.inputs

import com.pulumi.azurenative.maintenance.inputs.GetConfigurationAssignmentsForSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationAssignmentName Configuration assignment name
 */
public data class GetConfigurationAssignmentsForSubscriptionPlainArgs(
    public val configurationAssignmentName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.maintenance.inputs.GetConfigurationAssignmentsForSubscriptionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.maintenance.inputs.GetConfigurationAssignmentsForSubscriptionPlainArgs =
        com.pulumi.azurenative.maintenance.inputs.GetConfigurationAssignmentsForSubscriptionPlainArgs.builder()
            .configurationAssignmentName(configurationAssignmentName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationAssignmentsForSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationAssignmentsForSubscriptionPlainArgsBuilder internal constructor() {
    private var configurationAssignmentName: String? = null

    /**
     * @param value Configuration assignment name
     */
    @JvmName("ifceqlnyjwctrenr")
    public suspend fun configurationAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationAssignmentName = mapped
    }

    internal fun build(): GetConfigurationAssignmentsForSubscriptionPlainArgs =
        GetConfigurationAssignmentsForSubscriptionPlainArgs(
            configurationAssignmentName = configurationAssignmentName ?: throw
                PulumiNullFieldException("configurationAssignmentName"),
        )
}
