@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.inputs

import com.pulumi.azurenative.maintenance.inputs.InputPatchConfigurationArgs.builder
import com.pulumi.azurenative.maintenance.kotlin.enums.RebootOptions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input configuration for a patch run
 * @property linuxParameters Input parameters specific to patching Linux machine. For Windows machines, do not pass this property.
 * @property postTasks List of post tasks. e.g. [{'source' :'runbook', 'taskScope': 'Resource', 'parameters': { 'arg1': 'value1'}}]
 * @property preTasks List of pre tasks. e.g. [{'source' :'runbook', 'taskScope': 'Global', 'parameters': { 'arg1': 'value1'}}]
 * @property rebootSetting Possible reboot preference as defined by the user based on which it would be decided to reboot the machine or not after the patch operation is completed.
 * @property windowsParameters Input parameters specific to patching a Windows machine. For Linux machines, do not pass this property.
 */
public data class InputPatchConfigurationArgs(
    public val linuxParameters: Output<InputLinuxParametersArgs>? = null,
    public val postTasks: Output<List<TaskPropertiesArgs>>? = null,
    public val preTasks: Output<List<TaskPropertiesArgs>>? = null,
    public val rebootSetting: Output<Either<String, RebootOptions>>? = null,
    public val windowsParameters: Output<InputWindowsParametersArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.maintenance.inputs.InputPatchConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.maintenance.inputs.InputPatchConfigurationArgs =
        com.pulumi.azurenative.maintenance.inputs.InputPatchConfigurationArgs.builder()
            .linuxParameters(linuxParameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .postTasks(
                postTasks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .preTasks(
                preTasks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .rebootSetting(
                rebootSetting?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .windowsParameters(
                windowsParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [InputPatchConfigurationArgs].
 */
@PulumiTagMarker
public class InputPatchConfigurationArgsBuilder internal constructor() {
    private var linuxParameters: Output<InputLinuxParametersArgs>? = null

    private var postTasks: Output<List<TaskPropertiesArgs>>? = null

    private var preTasks: Output<List<TaskPropertiesArgs>>? = null

    private var rebootSetting: Output<Either<String, RebootOptions>>? = null

    private var windowsParameters: Output<InputWindowsParametersArgs>? = null

    /**
     * @param value Input parameters specific to patching Linux machine. For Windows machines, do not pass this property.
     */
    @JvmName("icgbbsnratsltrkn")
    public suspend fun linuxParameters(`value`: Output<InputLinuxParametersArgs>) {
        this.linuxParameters = value
    }

    /**
     * @param value List of post tasks. e.g. [{'source' :'runbook', 'taskScope': 'Resource', 'parameters': { 'arg1': 'value1'}}]
     */
    @JvmName("vhxaokryvuwqgsmh")
    public suspend fun postTasks(`value`: Output<List<TaskPropertiesArgs>>) {
        this.postTasks = value
    }

    @JvmName("jxpglqkudfxevmnt")
    public suspend fun postTasks(vararg values: Output<TaskPropertiesArgs>) {
        this.postTasks = Output.all(values.asList())
    }

    /**
     * @param values List of post tasks. e.g. [{'source' :'runbook', 'taskScope': 'Resource', 'parameters': { 'arg1': 'value1'}}]
     */
    @JvmName("gllhjlimjpgugesi")
    public suspend fun postTasks(values: List<Output<TaskPropertiesArgs>>) {
        this.postTasks = Output.all(values)
    }

    /**
     * @param value List of pre tasks. e.g. [{'source' :'runbook', 'taskScope': 'Global', 'parameters': { 'arg1': 'value1'}}]
     */
    @JvmName("krebjkmmdlwcqion")
    public suspend fun preTasks(`value`: Output<List<TaskPropertiesArgs>>) {
        this.preTasks = value
    }

    @JvmName("pvaeklipoybabgxu")
    public suspend fun preTasks(vararg values: Output<TaskPropertiesArgs>) {
        this.preTasks = Output.all(values.asList())
    }

    /**
     * @param values List of pre tasks. e.g. [{'source' :'runbook', 'taskScope': 'Global', 'parameters': { 'arg1': 'value1'}}]
     */
    @JvmName("viglycxynpluqbcs")
    public suspend fun preTasks(values: List<Output<TaskPropertiesArgs>>) {
        this.preTasks = Output.all(values)
    }

    /**
     * @param value Possible reboot preference as defined by the user based on which it would be decided to reboot the machine or not after the patch operation is completed.
     */
    @JvmName("jwoswgwcwsjngmog")
    public suspend fun rebootSetting(`value`: Output<Either<String, RebootOptions>>) {
        this.rebootSetting = value
    }

    /**
     * @param value Input parameters specific to patching a Windows machine. For Linux machines, do not pass this property.
     */
    @JvmName("qiinyfofungouttj")
    public suspend fun windowsParameters(`value`: Output<InputWindowsParametersArgs>) {
        this.windowsParameters = value
    }

    /**
     * @param value Input parameters specific to patching Linux machine. For Windows machines, do not pass this property.
     */
    @JvmName("qqcemhtvjmrtprcf")
    public suspend fun linuxParameters(`value`: InputLinuxParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxParameters = mapped
    }

    /**
     * @param argument Input parameters specific to patching Linux machine. For Windows machines, do not pass this property.
     */
    @JvmName("qbrpdtfygccmnweh")
    public suspend fun linuxParameters(argument: suspend InputLinuxParametersArgsBuilder.() -> Unit) {
        val toBeMapped = InputLinuxParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linuxParameters = mapped
    }

    /**
     * @param value List of post tasks. e.g. [{'source' :'runbook', 'taskScope': 'Resource', 'parameters': { 'arg1': 'value1'}}]
     */
    @JvmName("baokibyadembtfon")
    public suspend fun postTasks(`value`: List<TaskPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postTasks = mapped
    }

    /**
     * @param argument List of post tasks. e.g. [{'source' :'runbook', 'taskScope': 'Resource', 'parameters': { 'arg1': 'value1'}}]
     */
    @JvmName("rncutwaptitsovnj")
    public suspend fun postTasks(argument: List<suspend TaskPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TaskPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.postTasks = mapped
    }

    /**
     * @param argument List of post tasks. e.g. [{'source' :'runbook', 'taskScope': 'Resource', 'parameters': { 'arg1': 'value1'}}]
     */
    @JvmName("gufqjpdnpignfgge")
    public suspend fun postTasks(vararg argument: suspend TaskPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TaskPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.postTasks = mapped
    }

    /**
     * @param argument List of post tasks. e.g. [{'source' :'runbook', 'taskScope': 'Resource', 'parameters': { 'arg1': 'value1'}}]
     */
    @JvmName("toectmntlkauhuws")
    public suspend fun postTasks(argument: suspend TaskPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TaskPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.postTasks = mapped
    }

    /**
     * @param values List of post tasks. e.g. [{'source' :'runbook', 'taskScope': 'Resource', 'parameters': { 'arg1': 'value1'}}]
     */
    @JvmName("noomlgokgfjjddjk")
    public suspend fun postTasks(vararg values: TaskPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.postTasks = mapped
    }

    /**
     * @param value List of pre tasks. e.g. [{'source' :'runbook', 'taskScope': 'Global', 'parameters': { 'arg1': 'value1'}}]
     */
    @JvmName("crgxnleiwpaqrlpm")
    public suspend fun preTasks(`value`: List<TaskPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preTasks = mapped
    }

    /**
     * @param argument List of pre tasks. e.g. [{'source' :'runbook', 'taskScope': 'Global', 'parameters': { 'arg1': 'value1'}}]
     */
    @JvmName("basvwtjiyoupnily")
    public suspend fun preTasks(argument: List<suspend TaskPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TaskPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.preTasks = mapped
    }

    /**
     * @param argument List of pre tasks. e.g. [{'source' :'runbook', 'taskScope': 'Global', 'parameters': { 'arg1': 'value1'}}]
     */
    @JvmName("mspudmnowaykawlr")
    public suspend fun preTasks(vararg argument: suspend TaskPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TaskPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.preTasks = mapped
    }

    /**
     * @param argument List of pre tasks. e.g. [{'source' :'runbook', 'taskScope': 'Global', 'parameters': { 'arg1': 'value1'}}]
     */
    @JvmName("rhvfguvicxgnrrkp")
    public suspend fun preTasks(argument: suspend TaskPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TaskPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.preTasks = mapped
    }

    /**
     * @param values List of pre tasks. e.g. [{'source' :'runbook', 'taskScope': 'Global', 'parameters': { 'arg1': 'value1'}}]
     */
    @JvmName("jwetnplbsnpxbgda")
    public suspend fun preTasks(vararg values: TaskPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preTasks = mapped
    }

    /**
     * @param value Possible reboot preference as defined by the user based on which it would be decided to reboot the machine or not after the patch operation is completed.
     */
    @JvmName("fcwkegwxothomprw")
    public suspend fun rebootSetting(`value`: Either<String, RebootOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rebootSetting = mapped
    }

    /**
     * @param value Possible reboot preference as defined by the user based on which it would be decided to reboot the machine or not after the patch operation is completed.
     */
    @JvmName("nkxwcbsrnvkxurhv")
    public fun rebootSetting(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RebootOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rebootSetting = mapped
    }

    /**
     * @param value Possible reboot preference as defined by the user based on which it would be decided to reboot the machine or not after the patch operation is completed.
     */
    @JvmName("aekeuvqilfglcmfa")
    public fun rebootSetting(`value`: RebootOptions) {
        val toBeMapped = Either.ofRight<String, RebootOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rebootSetting = mapped
    }

    /**
     * @param value Input parameters specific to patching a Windows machine. For Linux machines, do not pass this property.
     */
    @JvmName("evvyqievwvqsaukh")
    public suspend fun windowsParameters(`value`: InputWindowsParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsParameters = mapped
    }

    /**
     * @param argument Input parameters specific to patching a Windows machine. For Linux machines, do not pass this property.
     */
    @JvmName("opvoglmaeeafvexd")
    public suspend
    fun windowsParameters(argument: suspend InputWindowsParametersArgsBuilder.() -> Unit) {
        val toBeMapped = InputWindowsParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.windowsParameters = mapped
    }

    internal fun build(): InputPatchConfigurationArgs = InputPatchConfigurationArgs(
        linuxParameters = linuxParameters,
        postTasks = postTasks,
        preTasks = preTasks,
        rebootSetting = rebootSetting,
        windowsParameters = windowsParameters,
    )
}
