@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedidentity.kotlin.inputs

import com.pulumi.azurenative.managedidentity.inputs.GetFederatedIdentityCredentialPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property federatedIdentityCredentialResourceName The name of the federated identity credential resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the identity resource.
 */
public data class GetFederatedIdentityCredentialPlainArgs(
    public val federatedIdentityCredentialResourceName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managedidentity.inputs.GetFederatedIdentityCredentialPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managedidentity.inputs.GetFederatedIdentityCredentialPlainArgs =
        com.pulumi.azurenative.managedidentity.inputs.GetFederatedIdentityCredentialPlainArgs.builder()
            .federatedIdentityCredentialResourceName(
                federatedIdentityCredentialResourceName.let({ args0 ->
                    args0
                }),
            )
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFederatedIdentityCredentialPlainArgs].
 */
@PulumiTagMarker
public class GetFederatedIdentityCredentialPlainArgsBuilder internal constructor() {
    private var federatedIdentityCredentialResourceName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the federated identity credential resource.
     */
    @JvmName("bunbobkwcflmgfcu")
    public suspend fun federatedIdentityCredentialResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.federatedIdentityCredentialResourceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dukljsusskxstvwa")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the identity resource.
     */
    @JvmName("wjjnohlblrcdsxoq")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetFederatedIdentityCredentialPlainArgs =
        GetFederatedIdentityCredentialPlainArgs(
            federatedIdentityCredentialResourceName = federatedIdentityCredentialResourceName ?: throw
                PulumiNullFieldException("federatedIdentityCredentialResourceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        )
}
