@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin.inputs

import com.pulumi.azurenative.managednetwork.inputs.GetManagedNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managedNetworkName The name of the Managed Network.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetManagedNetworkPlainArgs(
    public val managedNetworkName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.managednetwork.inputs.GetManagedNetworkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetwork.inputs.GetManagedNetworkPlainArgs =
        com.pulumi.azurenative.managednetwork.inputs.GetManagedNetworkPlainArgs.builder()
            .managedNetworkName(managedNetworkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedNetworkPlainArgs].
 */
@PulumiTagMarker
public class GetManagedNetworkPlainArgsBuilder internal constructor() {
    private var managedNetworkName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Managed Network.
     */
    @JvmName("qyxdkobqtbcalial")
    public suspend fun managedNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedNetworkName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("atgwicpdwiavwppo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedNetworkPlainArgs = GetManagedNetworkPlainArgs(
        managedNetworkName = managedNetworkName ?: throw PulumiNullFieldException("managedNetworkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
