@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin.inputs

import com.pulumi.azurenative.managednetwork.inputs.ManagedNetworkPeeringPolicyPropertiesArgs.builder
import com.pulumi.azurenative.managednetwork.kotlin.enums.Type
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of a Managed Network Peering Policy
 * @property hub Gets or sets the hub virtual network ID
 * @property mesh Gets or sets the mesh group IDs
 * @property spokes Gets or sets the spokes group IDs
 * @property type Gets or sets the connectivity type of a network structure policy
 */
public data class ManagedNetworkPeeringPolicyPropertiesArgs(
    public val hub: Output<ResourceIdArgs>? = null,
    public val mesh: Output<List<ResourceIdArgs>>? = null,
    public val spokes: Output<List<ResourceIdArgs>>? = null,
    public val type: Output<Either<String, Type>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetwork.inputs.ManagedNetworkPeeringPolicyPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetwork.inputs.ManagedNetworkPeeringPolicyPropertiesArgs =
        com.pulumi.azurenative.managednetwork.inputs.ManagedNetworkPeeringPolicyPropertiesArgs.builder()
            .hub(hub?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mesh(mesh?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .spokes(spokes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedNetworkPeeringPolicyPropertiesArgs].
 */
@PulumiTagMarker
public class ManagedNetworkPeeringPolicyPropertiesArgsBuilder internal constructor() {
    private var hub: Output<ResourceIdArgs>? = null

    private var mesh: Output<List<ResourceIdArgs>>? = null

    private var spokes: Output<List<ResourceIdArgs>>? = null

    private var type: Output<Either<String, Type>>? = null

    /**
     * @param value Gets or sets the hub virtual network ID
     */
    @JvmName("aoyihidtfhjxhwef")
    public suspend fun hub(`value`: Output<ResourceIdArgs>) {
        this.hub = value
    }

    /**
     * @param value Gets or sets the mesh group IDs
     */
    @JvmName("cpypeotsxscdhmva")
    public suspend fun mesh(`value`: Output<List<ResourceIdArgs>>) {
        this.mesh = value
    }

    @JvmName("knifhmgwwowdyqta")
    public suspend fun mesh(vararg values: Output<ResourceIdArgs>) {
        this.mesh = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the mesh group IDs
     */
    @JvmName("sxigqbbmidejucxw")
    public suspend fun mesh(values: List<Output<ResourceIdArgs>>) {
        this.mesh = Output.all(values)
    }

    /**
     * @param value Gets or sets the spokes group IDs
     */
    @JvmName("frfhbrfehmklwvkr")
    public suspend fun spokes(`value`: Output<List<ResourceIdArgs>>) {
        this.spokes = value
    }

    @JvmName("bnxfwvswgcjemslb")
    public suspend fun spokes(vararg values: Output<ResourceIdArgs>) {
        this.spokes = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the spokes group IDs
     */
    @JvmName("darfyalmcmulgulg")
    public suspend fun spokes(values: List<Output<ResourceIdArgs>>) {
        this.spokes = Output.all(values)
    }

    /**
     * @param value Gets or sets the connectivity type of a network structure policy
     */
    @JvmName("ldhhkivaiqsclcqw")
    public suspend fun type(`value`: Output<Either<String, Type>>) {
        this.type = value
    }

    /**
     * @param value Gets or sets the hub virtual network ID
     */
    @JvmName("tpbvirkvfsvtmyeu")
    public suspend fun hub(`value`: ResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hub = mapped
    }

    /**
     * @param argument Gets or sets the hub virtual network ID
     */
    @JvmName("lwvkuhfaabllxsbg")
    public suspend fun hub(argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hub = mapped
    }

    /**
     * @param value Gets or sets the mesh group IDs
     */
    @JvmName("btlekqsroufjedkw")
    public suspend fun mesh(`value`: List<ResourceIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mesh = mapped
    }

    /**
     * @param argument Gets or sets the mesh group IDs
     */
    @JvmName("qakaejatfopbrqil")
    public suspend fun mesh(argument: List<suspend ResourceIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.mesh = mapped
    }

    /**
     * @param argument Gets or sets the mesh group IDs
     */
    @JvmName("desxgwfmitkvmwox")
    public suspend fun mesh(vararg argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.mesh = mapped
    }

    /**
     * @param argument Gets or sets the mesh group IDs
     */
    @JvmName("nujnagurncvhsvns")
    public suspend fun mesh(argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceIdArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.mesh = mapped
    }

    /**
     * @param values Gets or sets the mesh group IDs
     */
    @JvmName("ekxgpauqaojyauja")
    public suspend fun mesh(vararg values: ResourceIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mesh = mapped
    }

    /**
     * @param value Gets or sets the spokes group IDs
     */
    @JvmName("cuqqsdpeencdsjhr")
    public suspend fun spokes(`value`: List<ResourceIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spokes = mapped
    }

    /**
     * @param argument Gets or sets the spokes group IDs
     */
    @JvmName("qdcysndimoovxock")
    public suspend fun spokes(argument: List<suspend ResourceIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.spokes = mapped
    }

    /**
     * @param argument Gets or sets the spokes group IDs
     */
    @JvmName("asxbrctuxeoryxfp")
    public suspend fun spokes(vararg argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.spokes = mapped
    }

    /**
     * @param argument Gets or sets the spokes group IDs
     */
    @JvmName("pfefnynakmswqlkv")
    public suspend fun spokes(argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceIdArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.spokes = mapped
    }

    /**
     * @param values Gets or sets the spokes group IDs
     */
    @JvmName("cpxxmrlqxfhsrxql")
    public suspend fun spokes(vararg values: ResourceIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.spokes = mapped
    }

    /**
     * @param value Gets or sets the connectivity type of a network structure policy
     */
    @JvmName("dyojslvqxisuagpw")
    public suspend fun type(`value`: Either<String, Type>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Gets or sets the connectivity type of a network structure policy
     */
    @JvmName("ctjtchwjoehevgro")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Gets or sets the connectivity type of a network structure policy
     */
    @JvmName("qoelvqmlefivajaa")
    public fun type(`value`: Type) {
        val toBeMapped = Either.ofRight<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ManagedNetworkPeeringPolicyPropertiesArgs =
        ManagedNetworkPeeringPolicyPropertiesArgs(
            hub = hub,
            mesh = mesh,
            spokes = spokes,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
