@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.AccessControlListConditionPropertiesResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.AccessControlListConditionPropertiesResponse.Companion.toKotlin as accessControlListConditionPropertiesResponseToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AccessControlList].
 */
@PulumiTagMarker
public class AccessControlListResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessControlListArgs = AccessControlListArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessControlListArgsBuilder.() -> Unit) {
        val builder = AccessControlListArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AccessControlList {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.AccessControlList(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AccessControlList(builtJavaResource)
    }
}

/**
 * The AccessControlList resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### AccessControlLists_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accessControlList = new AzureNative.ManagedNetworkFabric.AccessControlList("accessControlList", new()
 *     {
 *         AccessControlListName = "aclOne",
 *         AddressFamily = "ipv4",
 *         Conditions = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.AccessControlListConditionPropertiesArgs
 *             {
 *                 Action = "allow",
 *                 DestinationAddress = "1.1.1.1",
 *                 DestinationPort = "21",
 *                 Protocol = 6,
 *                 SequenceNumber = 3,
 *                 SourceAddress = "2.2.2.2",
 *                 SourcePort = "65000",
 *             },
 *         },
 *         Location = "EastUs",
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewAccessControlList(ctx, "accessControlList", &managednetworkfabric.AccessControlListArgs{
 * 			AccessControlListName: pulumi.String("aclOne"),
 * 			AddressFamily:         pulumi.String("ipv4"),
 * 			Conditions: []managednetworkfabric.AccessControlListConditionPropertiesArgs{
 * 				{
 * 					Action:             pulumi.String("allow"),
 * 					DestinationAddress: pulumi.String("1.1.1.1"),
 * 					DestinationPort:    pulumi.String("21"),
 * 					Protocol:           pulumi.Int(6),
 * 					SequenceNumber:     pulumi.Int(3),
 * 					SourceAddress:      pulumi.String("2.2.2.2"),
 * 					SourcePort:         pulumi.String("65000"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("EastUs"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.AccessControlList;
 * import com.pulumi.azurenative.managednetworkfabric.AccessControlListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accessControlList = new AccessControlList("accessControlList", AccessControlListArgs.builder()
 *             .accessControlListName("aclOne")
 *             .addressFamily("ipv4")
 *             .conditions(Map.ofEntries(
 *                 Map.entry("action", "allow"),
 *                 Map.entry("destinationAddress", "1.1.1.1"),
 *                 Map.entry("destinationPort", "21"),
 *                 Map.entry("protocol", 6),
 *                 Map.entry("sequenceNumber", 3),
 *                 Map.entry("sourceAddress", "2.2.2.2"),
 *                 Map.entry("sourcePort", "65000")
 *             ))
 *             .location("EastUs")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:AccessControlList aaaaaaaaaaaaaa /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/accessControlLists/{accessControlListName}
 * ```
 */
public class AccessControlList internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.AccessControlList,
) : KotlinCustomResource(javaResource, AccessControlListMapper) {
    /**
     * IP address family. Example: ipv4 | ipv6.
     */
    public val addressFamily: Output<String>
        get() = javaResource.addressFamily().applyValue({ args0 -> args0 })

    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Access Control List conditions.
     */
    public val conditions: Output<List<AccessControlListConditionPropertiesResponse>>
        get() = javaResource.conditions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    accessControlListConditionPropertiesResponseToKotlin(args0)
                })
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AccessControlListMapper : ResourceMapper<AccessControlList> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.AccessControlList::class == javaResource::class

    override fun map(javaResource: Resource): AccessControlList = AccessControlList(
        javaResource as
            com.pulumi.azurenative.managednetworkfabric.AccessControlList,
    )
}

/**
 * @see [AccessControlList].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessControlList].
 */
public suspend fun accessControlList(
    name: String,
    block: suspend AccessControlListResourceBuilder.() -> Unit,
): AccessControlList {
    val builder = AccessControlListResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessControlList].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessControlList(name: String): AccessControlList {
    val builder = AccessControlListResourceBuilder()
    builder.name(name)
    return builder.build()
}
