@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.InternetGatewayArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.GatewayType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Internet Gateway resource definition.
 * Azure REST API version: 2023-06-15.
 * ## Example Usage
 * ### InternetGateways_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var internetGateway = new AzureNative.ManagedNetworkFabric.InternetGateway("internetGateway", new()
 *     {
 *         Annotation = "annotation",
 *         InternetGatewayName = "example-internetGateway",
 *         InternetGatewayRuleId = "/subscriptions/xxxx-xxxx-xxxx-xxxx/providers/Microsoft.ManagedNetworkFabric/internetGatewayRules/example-internetGatewayRule",
 *         Location = "eastus",
 *         NetworkFabricControllerId = "/subscriptions/xxxx-xxxx-xxxx-xxxx/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/example-networkFabricController",
 *         ResourceGroupName = "example-rg",
 *         Tags =
 *         {
 *             { "key3540", "1234" },
 *         },
 *         Type = "Infrastructure",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewInternetGateway(ctx, "internetGateway", &managednetworkfabric.InternetGatewayArgs{
 * 			Annotation:                pulumi.String("annotation"),
 * 			InternetGatewayName:       pulumi.String("example-internetGateway"),
 * 			InternetGatewayRuleId:     pulumi.String("/subscriptions/xxxx-xxxx-xxxx-xxxx/providers/Microsoft.ManagedNetworkFabric/internetGatewayRules/example-internetGatewayRule"),
 * 			Location:                  pulumi.String("eastus"),
 * 			NetworkFabricControllerId: pulumi.String("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/example-networkFabricController"),
 * 			ResourceGroupName:         pulumi.String("example-rg"),
 * 			Tags: pulumi.StringMap{
 * 				"key3540": pulumi.String("1234"),
 * 			},
 * 			Type: pulumi.String("Infrastructure"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.InternetGateway;
 * import com.pulumi.azurenative.managednetworkfabric.InternetGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var internetGateway = new InternetGateway("internetGateway", InternetGatewayArgs.builder()
 *             .annotation("annotation")
 *             .internetGatewayName("example-internetGateway")
 *             .internetGatewayRuleId("/subscriptions/xxxx-xxxx-xxxx-xxxx/providers/Microsoft.ManagedNetworkFabric/internetGatewayRules/example-internetGatewayRule")
 *             .location("eastus")
 *             .networkFabricControllerId("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/example-networkFabricController")
 *             .resourceGroupName("example-rg")
 *             .tags(Map.of("key3540", "1234"))
 *             .type("Infrastructure")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:InternetGateway example-internetGateway /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/internetGateways/{internetGatewayName}
 * ```
 * @property annotation Switch configuration description.
 * @property internetGatewayName Name of the Internet Gateway.
 * @property internetGatewayRuleId ARM Resource ID of the Internet Gateway Rule.
 * @property location The geo-location where the resource lives
 * @property networkFabricControllerId ARM Resource ID of the Network Fabric Controller.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property type Gateway Type of the resource.
 */
public data class InternetGatewayArgs(
    public val `annotation`: Output<String>? = null,
    public val internetGatewayName: Output<String>? = null,
    public val internetGatewayRuleId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val networkFabricControllerId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<Either<String, GatewayType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.InternetGatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.InternetGatewayArgs =
        com.pulumi.azurenative.managednetworkfabric.InternetGatewayArgs.builder()
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .internetGatewayName(internetGatewayName?.applyValue({ args0 -> args0 }))
            .internetGatewayRuleId(internetGatewayRuleId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkFabricControllerId(networkFabricControllerId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [InternetGatewayArgs].
 */
@PulumiTagMarker
public class InternetGatewayArgsBuilder internal constructor() {
    private var `annotation`: Output<String>? = null

    private var internetGatewayName: Output<String>? = null

    private var internetGatewayRuleId: Output<String>? = null

    private var location: Output<String>? = null

    private var networkFabricControllerId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<Either<String, GatewayType>>? = null

    /**
     * @param value Switch configuration description.
     */
    @JvmName("mmroybkxlyajeuag")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value Name of the Internet Gateway.
     */
    @JvmName("qhxutisfcibisjts")
    public suspend fun internetGatewayName(`value`: Output<String>) {
        this.internetGatewayName = value
    }

    /**
     * @param value ARM Resource ID of the Internet Gateway Rule.
     */
    @JvmName("ttgprleyiqykwgij")
    public suspend fun internetGatewayRuleId(`value`: Output<String>) {
        this.internetGatewayRuleId = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hjyvxwivtjhgrnvf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value ARM Resource ID of the Network Fabric Controller.
     */
    @JvmName("wtrywsxikffvaaxe")
    public suspend fun networkFabricControllerId(`value`: Output<String>) {
        this.networkFabricControllerId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mkyrvnbhbsxxrhpv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("twagvotrvmoiganb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gateway Type of the resource.
     */
    @JvmName("wvmpygxuanbdjsux")
    public suspend fun type(`value`: Output<Either<String, GatewayType>>) {
        this.type = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("bdyxxglnvotqbbjc")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value Name of the Internet Gateway.
     */
    @JvmName("kxvnhmshmmdfnomf")
    public suspend fun internetGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetGatewayName = mapped
    }

    /**
     * @param value ARM Resource ID of the Internet Gateway Rule.
     */
    @JvmName("onhyklkueyyabihx")
    public suspend fun internetGatewayRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetGatewayRuleId = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ganufdhpnmhowsms")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value ARM Resource ID of the Network Fabric Controller.
     */
    @JvmName("jksmhwcbehmsbysr")
    public suspend fun networkFabricControllerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFabricControllerId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jwjjtvlijidcjxny")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wybfombiuipxqlnu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tjhtttyfdmsihiwb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Gateway Type of the resource.
     */
    @JvmName("xiamagwslqgfpmkb")
    public suspend fun type(`value`: Either<String, GatewayType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Gateway Type of the resource.
     */
    @JvmName("fmglthtpbxontuhr")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GatewayType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Gateway Type of the resource.
     */
    @JvmName("xafwfgtmxtuyfmbl")
    public fun type(`value`: GatewayType) {
        val toBeMapped = Either.ofRight<String, GatewayType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): InternetGatewayArgs = InternetGatewayArgs(
        `annotation` = `annotation`,
        internetGatewayName = internetGatewayName,
        internetGatewayRuleId = internetGatewayRuleId,
        location = location,
        networkFabricControllerId = networkFabricControllerId,
        resourceGroupName = resourceGroupName,
        tags = tags,
        type = type,
    )
}
