@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.IpCommunityArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.CommunityActionTypes
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.WellKnownCommunities
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The IpCommunity resource definition.
 * Azure REST API version: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### IpCommunities_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipCommunity = new AzureNative.ManagedNetworkFabric.IpCommunity("ipCommunity", new()
 *     {
 *         Action = "Permit",
 *         Annotation = "annotationValue",
 *         CommunityMembers = new[]
 *         {
 *             "1234:5678",
 *         },
 *         IpCommunityName = "example-ipCommunity",
 *         Location = "EastUS",
 *         ResourceGroupName = "rgIpCommunityLists",
 *         Tags =
 *         {
 *             { "key2814", "" },
 *         },
 *         WellKnownCommunities = new[]
 *         {
 *             "Internet",
 *             "LocalAS",
 *             "NoExport",
 *             "GShut",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewIpCommunity(ctx, "ipCommunity", &managednetworkfabric.IpCommunityArgs{
 * 			Action:     pulumi.String("Permit"),
 * 			Annotation: pulumi.String("annotationValue"),
 * 			CommunityMembers: pulumi.StringArray{
 * 				pulumi.String("1234:5678"),
 * 			},
 * 			IpCommunityName:   pulumi.String("example-ipCommunity"),
 * 			Location:          pulumi.String("EastUS"),
 * 			ResourceGroupName: pulumi.String("rgIpCommunityLists"),
 * 			Tags: pulumi.StringMap{
 * 				"key2814": pulumi.String(""),
 * 			},
 * 			WellKnownCommunities: pulumi.StringArray{
 * 				pulumi.String("Internet"),
 * 				pulumi.String("LocalAS"),
 * 				pulumi.String("NoExport"),
 * 				pulumi.String("GShut"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.IpCommunity;
 * import com.pulumi.azurenative.managednetworkfabric.IpCommunityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipCommunity = new IpCommunity("ipCommunity", IpCommunityArgs.builder()
 *             .action("Permit")
 *             .annotation("annotationValue")
 *             .communityMembers("1234:5678")
 *             .ipCommunityName("example-ipCommunity")
 *             .location("EastUS")
 *             .resourceGroupName("rgIpCommunityLists")
 *             .tags(Map.of("key2814", ""))
 *             .wellKnownCommunities(
 *                 "Internet",
 *                 "LocalAS",
 *                 "NoExport",
 *                 "GShut")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:IpCommunity example-ipCommunity /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipCommunities/{ipCommunityName}
 * ```
 * @property action Action to be taken on the configuration. Example: Permit | Deny.
 * @property annotation Switch configuration description.
 * @property communityMembers List the communityMembers of IP Community .
 * @property ipCommunityName Name of the IP Community
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property wellKnownCommunities Supported well known Community List.
 */
public data class IpCommunityArgs(
    public val action: Output<Either<String, CommunityActionTypes>>? = null,
    public val `annotation`: Output<String>? = null,
    public val communityMembers: Output<List<String>>? = null,
    public val ipCommunityName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val wellKnownCommunities: Output<List<Either<String, WellKnownCommunities>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.IpCommunityArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.IpCommunityArgs =
        com.pulumi.azurenative.managednetworkfabric.IpCommunityArgs.builder()
            .action(
                action?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .communityMembers(communityMembers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipCommunityName(ipCommunityName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .wellKnownCommunities(
                wellKnownCommunities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IpCommunityArgs].
 */
@PulumiTagMarker
public class IpCommunityArgsBuilder internal constructor() {
    private var action: Output<Either<String, CommunityActionTypes>>? = null

    private var `annotation`: Output<String>? = null

    private var communityMembers: Output<List<String>>? = null

    private var ipCommunityName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var wellKnownCommunities: Output<List<Either<String, WellKnownCommunities>>>? = null

    /**
     * @param value Action to be taken on the configuration. Example: Permit | Deny.
     */
    @JvmName("adysbvhlsggueiar")
    public suspend fun action(`value`: Output<Either<String, CommunityActionTypes>>) {
        this.action = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("ygiftcldnqnkefei")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value List the communityMembers of IP Community .
     */
    @JvmName("wqvcbgdfnnrdhrhq")
    public suspend fun communityMembers(`value`: Output<List<String>>) {
        this.communityMembers = value
    }

    @JvmName("hgqffdnsiskkdtvs")
    public suspend fun communityMembers(vararg values: Output<String>) {
        this.communityMembers = Output.all(values.asList())
    }

    /**
     * @param values List the communityMembers of IP Community .
     */
    @JvmName("gljvgmjbiabgbggd")
    public suspend fun communityMembers(values: List<Output<String>>) {
        this.communityMembers = Output.all(values)
    }

    /**
     * @param value Name of the IP Community
     */
    @JvmName("kffuqamccwcocsfr")
    public suspend fun ipCommunityName(`value`: Output<String>) {
        this.ipCommunityName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tjxsrgnvuoovvgmu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fcnabrjcnnurtvdx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ruvyjekpsyoniktp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Supported well known Community List.
     */
    @JvmName("qcedhtapvlfraxnx")
    public suspend
    fun wellKnownCommunities(`value`: Output<List<Either<String, WellKnownCommunities>>>) {
        this.wellKnownCommunities = value
    }

    @JvmName("kwhlwccegyalgqef")
    public suspend fun wellKnownCommunities(
        vararg
        values: Output<Either<String, WellKnownCommunities>>,
    ) {
        this.wellKnownCommunities = Output.all(values.asList())
    }

    /**
     * @param values Supported well known Community List.
     */
    @JvmName("mavlstlolmwilyoc")
    public suspend
    fun wellKnownCommunities(values: List<Output<Either<String, WellKnownCommunities>>>) {
        this.wellKnownCommunities = Output.all(values)
    }

    /**
     * @param value Action to be taken on the configuration. Example: Permit | Deny.
     */
    @JvmName("qjptncdxxypsopum")
    public suspend fun action(`value`: Either<String, CommunityActionTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Action to be taken on the configuration. Example: Permit | Deny.
     */
    @JvmName("kjwqsijrdaqgxbkc")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CommunityActionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Action to be taken on the configuration. Example: Permit | Deny.
     */
    @JvmName("fwkkbhobaytatrcx")
    public fun action(`value`: CommunityActionTypes) {
        val toBeMapped = Either.ofRight<String, CommunityActionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("pjgcyxaitebqxfuu")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value List the communityMembers of IP Community .
     */
    @JvmName("oyoiyodbsjrewuww")
    public suspend fun communityMembers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.communityMembers = mapped
    }

    /**
     * @param values List the communityMembers of IP Community .
     */
    @JvmName("hufkvevftjffmees")
    public suspend fun communityMembers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.communityMembers = mapped
    }

    /**
     * @param value Name of the IP Community
     */
    @JvmName("hjnoqdhholgmrdok")
    public suspend fun ipCommunityName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipCommunityName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lawphsmcsnbmavyd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cnbgxaqnquciirch")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wryesukqxyrolijy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xtnmxevvdjrovqfo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Supported well known Community List.
     */
    @JvmName("hsgyyxdjuyerpavu")
    public suspend fun wellKnownCommunities(`value`: List<Either<String, WellKnownCommunities>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wellKnownCommunities = mapped
    }

    /**
     * @param values Supported well known Community List.
     */
    @JvmName("ibkimbbakqxexhkg")
    public suspend fun wellKnownCommunities(vararg values: Either<String, WellKnownCommunities>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.wellKnownCommunities = mapped
    }

    internal fun build(): IpCommunityArgs = IpCommunityArgs(
        action = action,
        `annotation` = `annotation`,
        communityMembers = communityMembers,
        ipCommunityName = ipCommunityName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        wellKnownCommunities = wellKnownCommunities,
    )
}
